package com.codingapi.sds.delivery.service;

import com.ysscale.socket.entity.Server;

import java.util.List;

/**
 * create by lorne on 2017/10/14
 */
public interface DeliveryServerService {

    String SOCKET_SERVER_KEY = "SOCKET-SERVER";

    /**
     * 获取健康的服务
     */
    Server getOkServer();

    /**
     * consul获取socket服务
     */
    List<Server> serverList();

    /**
     * consul获取socket服务并删除服务本地缓存
     */
    List<Server> serverList(String param);

    /**
     * @description: Consult 获取指定类型 socket服务并删除服务本地缓存
     **/
    List<Server> serverListWithType(String param, String sType, String dType);

    /**
     * @description: Consult 获取非指定类型其他 socket服务并删除服务本地缓存
     **/
    List<Server> serverListWithOutType(String param, String sType, String dType);

    /**
     * @description: 清空所有socket 本地缓存
     **/
    boolean clearAllSocketCache(String params);

    /**
     * consul获取或本地获取socket服务并删除对应本地缓存
     */
    List<Server> changeServerList(String param);

    /**
     * 热切换服务读取配置类型
     */
    boolean changeServerType(String key);

    /**
     * 获取设备服务状态
     */
    String getServerType();
}
