package com.codingapi.sds.delivery.service.impl;

import com.codingapi.sds.delivery.model.SocketDeliveryParam;
import com.codingapi.sds.delivery.model.SocketModel;
import com.codingapi.sds.delivery.service.OnlineService;
import com.codingapi.sds.delivery.service.RedisService;
import com.codingapi.sds.delivery.utils.DeliveryContent;
import com.lorne.core.framework.exception.ServiceException;
import com.ysscale.redis.service.RedisHandleService;
import com.ysscale.socket.vo.DeviceCheck;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * create by lorne on 2017/12/6
 */
@Service
public class OnLineServiceImpl implements OnlineService {


    @Autowired
    private RedisService redisService;

    @Autowired
    private RedisHandleService redisHandleService;

    @Override
    public boolean add(String modelName, String uniqueKey) {
        redisService.add(modelName, uniqueKey);
        return true;
    }

    @Override
    public boolean remove(String modelName, String uniqueKey) {
        redisService.remove(modelName, uniqueKey);
        return true;
    }


    @Override
    public boolean putKey(String modelName, String uniqueKey, String key) {
        redisService.putKey(modelName, uniqueKey, key);
        return true;
    }


    @Override
    public boolean check(String key) {
        String val = redisService.getModelByKey(key);
        if (StringUtils.isEmpty(val)) {
            return false;
        }
        return true;
    }

    @Override
    public List<DeviceCheck> checks(String keys) {
        List<DeviceCheck> deviceChecks = new ArrayList<>();
        String[] macs = keys.split(",");
        if (macs != null && macs.length != 0) {
            for (String mac : macs) {
                boolean res = false;
                String val = redisService.getModelByKey(mac);
                if (StringUtils.isNotBlank(val)) {
                    res = true;
                }
                deviceChecks.add(new DeviceCheck(mac, res));
            }
        }
        return deviceChecks;
    }

    /**
     * @param serverId
     * @description: 注册服务ID
     */
    @Override
    public boolean register(String serverId) {
        SocketDeliveryParam socketDeliveryParam = new SocketDeliveryParam(serverId, 0, 0);
        redisHandleService.addHashKey(DeliveryContent.DELIVERY, DeliveryContent.UPPER, serverId, socketDeliveryParam);
        return true;
    }

    /**
     * @param socketDeliveryParam
     * @description: 添加上线配置
     */
    @Override
    public boolean addSocketUpper(SocketDeliveryParam socketDeliveryParam) {
        redisHandleService.addHashKey(DeliveryContent.DELIVERY, DeliveryContent.UPPER, socketDeliveryParam.getServerId(), socketDeliveryParam);
        return true;
    }

    /**
     * @param serverId
     * @description: 删除上线配置
     */
    @Override
    public boolean delSocketUpper(String serverId) {
        redisHandleService.removeHashKey(DeliveryContent.DELIVERY, DeliveryContent.UPPER, serverId);
        return true;
    }

    /**
     * @description: 获取上线列表信息
     **/
    @Override
    public List getSocketUpper() {
        return redisHandleService.getHashValList(DeliveryContent.DELIVERY, DeliveryContent.UPPER);
    }

    /**
     * @param serverId
     * @description: 获取服务上线信息
     */
    @Override
    public SocketDeliveryParam getSocketUpper(String serverId) {
        return (SocketDeliveryParam) redisHandleService.getHashVal(DeliveryContent.DELIVERY, DeliveryContent.UPPER, serverId);
    }

    @Override
    public SocketModel getModelByKey(String key) throws ServiceException {

        String val = redisService.getModelByKey(key);
        if (StringUtils.isEmpty(val)) {
            throw new ServiceException("data not exist.");
        }

        String mv[] = val.split("#");
        SocketModel model = new SocketModel();
        model.setModelName(mv[0]);
        model.setUniqueKey(mv[1]);
        return model;
    }
}
