package com.codingapi.sds.delivery.service;

import com.codingapi.sds.delivery.model.SocketDeliveryParam;
import com.codingapi.sds.delivery.model.SocketModel;
import com.lorne.core.framework.exception.ServiceException;
import com.ysscale.socket.vo.DeviceCheck;

import java.util.List;

/**
 * create by lorne on 2017/12/6
 */
public interface OnlineService {

    boolean add(String modelName, String uniqueKey);

    boolean remove(String modelName, String uniqueKey);

    boolean putKey(String modelName, String uniqueKey, String key);

    SocketModel getModelByKey(String key) throws ServiceException;

    boolean check(String key);

    List<DeviceCheck> checks(String keys);

    /**
     * @description: 注册服务ID
     **/
    boolean register(String serverId);

    /**
     * @description: 添加上线配置
     **/
    boolean addSocketUpper(SocketDeliveryParam socketDeliveryParam);

    /**
     * @description: 删除上线配置
     **/
    boolean delSocketUpper(String serverId);

    /**
     * @description: 获取上线列表信息
     **/
    List getSocketUpper();

    /**
     * @description: 获取服务上线信息
     **/
    SocketDeliveryParam getSocketUpper(String serverId);
}
