package com.codingapi.sds.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.sds.delivery.model.SocketModel;
import com.codingapi.sds.delivery.service.OnlineService;
import com.codingapi.sds.delivery.service.SocketService;
import com.lorne.core.framework.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/**
 * create by lorne on 2017/10/10
 */
@Service
public class SocketServiceImpl implements SocketService {

    private static final Logger LOGGER = LoggerFactory.getLogger(SocketServiceImpl.class);


    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private OnlineService onlineService;


    /**
     * @param modelName
     * @param uniqueKey
     * @param cmd
     * @description: 异步发送命令
     */
    @Override
    @Async("cmdSendDelivery")
    public void ansySendHexCmd(String modelName, String uniqueKey, String cmd) {
        String url = "http://" + modelName + "/socket/sendHexCmd";
        LOGGER.info("sendHexCmd: url[" + url + "-" + uniqueKey + "]; CMD[" + cmd + "]");
        JSONObject msg = new JSONObject();
        msg.put("uniqueKey", uniqueKey);
        msg.put("cmd", cmd);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity(msg.toJSONString(), headers);
        restTemplate.postForObject(url, request, Boolean.class);
    }

    @Override
    public boolean sendHexCmd(String modelName, String uniqueKey, String cmd) throws ServiceException {
        ansySendHexCmd(modelName, uniqueKey, cmd);
        return true;
    }

    @Override
    public boolean sendHexCmdByKey(String key, String cmd) throws ServiceException {
        SocketModel socketModel = onlineService.getModelByKey(key);
        return sendHexCmd(socketModel.getModelName(), socketModel.getUniqueKey(), cmd);
    }


    @Override
    public boolean sendBase64Cmd(String modelName, String uniqueKey, String cmd) throws ServiceException {
        String url = "http://" + modelName + "/socket/sendBase64Cmd";
        return restTemplate.postForObject(url + "?uniqueKey={uniqueKey}&cmd={cmd}", null, Boolean.class, uniqueKey, cmd);
    }


    @Override
    public boolean sendStrCmd(String modelName, String uniqueKey, String cmd) throws ServiceException {
        String url = "http://" + modelName + "/socket/sendStrCmd";
        return restTemplate.postForObject(url + "?uniqueKey={uniqueKey}&cmd={cmd}", null, Boolean.class, uniqueKey, cmd);
    }

    @Override
    public SocketModel getServerByKey(String key) throws ServiceException {
        SocketModel socketModel = onlineService.getModelByKey(key);
        return socketModel;
    }

    @Override
    public boolean sendBase64CmdByKey(String key, String cmd) throws ServiceException {
        SocketModel socketModel = onlineService.getModelByKey(key);
        return sendBase64Cmd(socketModel.getModelName(), socketModel.getUniqueKey(), cmd);
    }

    @Override
    public boolean sendStrCmdByKey(String key, String cmd) throws ServiceException {
        SocketModel socketModel = onlineService.getModelByKey(key);
        return sendStrCmd(socketModel.getModelName(), socketModel.getUniqueKey(), cmd);
    }
}
