/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.sds.delivery.controller;

import com.codingapi.sds.delivery.model.SocketModel;
import com.codingapi.sds.delivery.service.DeliveryServerService;
import com.codingapi.sds.delivery.service.RedisService;
import com.codingapi.sds.delivery.service.SocketService;
import com.lorne.core.framework.exception.ServiceException;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/delivery"})
public class DeliveryController {
    @Autowired
    private SocketService socketService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private DeliveryServerService deliveryServerService;

    @RequestMapping(value={"/index"})
    public Set<String> index(@RequestParam(name="modelName") String modelName) {
        return this.redisService.all(modelName);
    }

    @RequestMapping(value={"/sendHexCmd"}, method={RequestMethod.POST})
    public boolean sendHexCmd(@RequestParam(name="modelName") String modelName, @RequestParam(name="uniqueKey") String uniqueKey, @RequestParam(name="cmd") String cmd) throws ServiceException {
        return this.socketService.sendHexCmd(modelName, uniqueKey, cmd);
    }

    @RequestMapping(value={"/sendHexCmdByKey"}, method={RequestMethod.POST})
    public boolean sendHexCmdByKey(@RequestParam(name="key") String key, @RequestParam(name="cmd") String cmd) throws ServiceException {
        return this.socketService.sendHexCmdByKey(key, cmd);
    }

    @RequestMapping(value={"/clearAllSocketCache"}, method={RequestMethod.POST})
    public boolean clearAllSocketCache(@RequestParam(name="params") String params) throws ServiceException {
        return this.deliveryServerService.clearAllSocketCache(params);
    }

    @RequestMapping(value={"/sendBase64Cmd"}, method={RequestMethod.POST})
    public boolean sendBase64Cmd(@RequestParam(name="modelName") String modelName, @RequestParam(name="uniqueKey") String uniqueKey, @RequestParam(name="cmd") String cmd) throws ServiceException {
        return this.socketService.sendBase64Cmd(modelName, uniqueKey, cmd);
    }

    @RequestMapping(value={"/sendStrCmd"}, method={RequestMethod.POST})
    public boolean sendStrCmd(@RequestParam(name="modelName") String modelName, @RequestParam(name="uniqueKey") String uniqueKey, @RequestParam(name="cmd") String cmd) throws ServiceException {
        return this.socketService.sendStrCmd(modelName, uniqueKey, cmd);
    }

    @RequestMapping(value={"/getServerByKey"}, method={RequestMethod.POST})
    public SocketModel getServerByKey(@RequestParam(name="key") String key) throws ServiceException {
        return this.socketService.getServerByKey(key);
    }

    @RequestMapping(value={"/sendBase64CmdByKey"}, method={RequestMethod.POST})
    public boolean sendBase64CmdByKey(@RequestParam(name="key") String key, @RequestParam(name="cmd") String cmd) throws ServiceException {
        return this.socketService.sendBase64CmdByKey(key, cmd);
    }

    @RequestMapping(value={"/sendStrCmdByKey"}, method={RequestMethod.POST})
    public boolean sendStrCmdByKey(@RequestParam(name="key") String key, @RequestParam(name="cmd") String cmd) throws ServiceException {
        return this.socketService.sendStrCmdByKey(key, cmd);
    }
}

