/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.sds.delivery.service.impl;

import com.codingapi.sds.delivery.config.DeliveryConfig;
import com.codingapi.sds.delivery.model.SocketDeliveryParam;
import com.codingapi.sds.delivery.service.DeliveryServerService;
import com.codingapi.sds.delivery.service.OnlineService;
import com.ysscale.framework.utils.JSONUtils;
import com.ysscale.socket.entity.Server;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class DeliveryServerServiceImpl
implements DeliveryServerService {
    private static final Logger log = LoggerFactory.getLogger(DeliveryServerServiceImpl.class);
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private RestTemplate restTemplate;
    private Boolean serverType;
    @Autowired
    private DeliveryConfig deliveryConfig;
    @Autowired
    private OnlineService onlineService;

    @Override
    public Server getOkServer() {
        List serviceInstances = this.discoveryClient.getInstances("SOCKET-SERVER");
        if (serviceInstances != null && serviceInstances.size() > 0) {
            for (ServiceInstance instance : serviceInstances) {
                Server server;
                URI uri = instance.getUri();
                if (uri == null || (server = (Server)this.restTemplate.getForObject(uri + "/socket/getServer", Server.class, new Object[0])).getNowCount() > server.getMaxCount()) continue;
                return server;
            }
        }
        return null;
    }

    @Override
    public List<Server> serverList() {
        List serviceInstances = this.discoveryClient.getInstances("SOCKET-SERVER");
        ArrayList<Server> servers = new ArrayList<Server>();
        if (serviceInstances != null && serviceInstances.size() > 0) {
            for (ServiceInstance instance : serviceInstances) {
                URI uri = instance.getUri();
                if (uri == null) continue;
                Server server = (Server)this.restTemplate.getForObject(uri + "/socket/getServer", Server.class, new Object[0]);
                servers.add(server);
            }
        }
        return servers;
    }

    @Override
    public List<Server> serverList(String param) {
        List serviceInstances = this.discoveryClient.getInstances("SOCKET-SERVER");
        ArrayList<Server> servers = new ArrayList<Server>();
        if (serviceInstances != null && serviceInstances.size() > 0) {
            for (ServiceInstance instance : serviceInstances) {
                Server server;
                URI uri = instance.getUri();
                if (uri == null || (server = (Server)this.restTemplate.getForObject(uri + "/socket/getServerParam?param={1}", Server.class, new Object[]{param})) == null) continue;
                servers.add(server);
            }
        }
        return servers;
    }

    @Override
    public List<Server> serverListWithType(String param, String sType, String dType) {
        List serviceInstances = this.discoveryClient.getInstances("SOCKET-SERVER");
        ArrayList<Server> servers = new ArrayList<Server>();
        if (serviceInstances != null && serviceInstances.size() > 0) {
            for (ServiceInstance instance : serviceInstances) {
                URI uri = instance.getUri();
                try {
                    if (uri == null) continue;
                    Server server = (Server)this.restTemplate.getForObject(uri + "/socket/getServerParam?param={1}", Server.class, new Object[]{param});
                    log.info("serverListWithType \u67e5\u8be2\u5230\u7684Socket\u4fe1\u606f\uff1a{}", (Object)JSONUtils.objectJsonParse((Object)server));
                    if (server == null || this.fiflterSocket(dType, server) || StringUtils.isNotBlank((String)sType) && !sType.equalsIgnoreCase(server.getType())) continue;
                    servers.add(server);
                }
                catch (Exception e) {
                    log.error("delivery serverListWithType socket link err", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return servers;
    }

    @Override
    public List<Server> serverListWithOutType(String param, String sType, String dType) {
        List serviceInstances = this.discoveryClient.getInstances("SOCKET-SERVER");
        ArrayList<Server> servers = new ArrayList<Server>();
        if (serviceInstances != null && serviceInstances.size() > 0) {
            for (ServiceInstance instance : serviceInstances) {
                URI uri = instance.getUri();
                try {
                    if (uri == null) continue;
                    Server server = (Server)this.restTemplate.getForObject(uri + "/socket/getServerParam?param={1}", Server.class, new Object[]{param});
                    log.info("serverListWithOutType \u67e5\u8be2\u5230\u7684Socket\u4fe1\u606f\uff1a{}", (Object)JSONUtils.objectJsonParse((Object)server));
                    if (server == null || this.fiflterSocket(dType, server) || StringUtils.isNotBlank((String)sType) && sType.equalsIgnoreCase(server.getType())) continue;
                    servers.add(server);
                }
                catch (Exception e) {
                    log.error("delivery serverListWithOutType socket link err", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return servers;
    }

    private boolean fiflterSocket(String dType, Server server) {
        SocketDeliveryParam socketUpper;
        if (StringUtils.isNotBlank((String)server.getServerId()) && Objects.nonNull(socketUpper = this.onlineService.getSocketUpper(server.getServerId()))) {
            if ("VC".equals(dType) && socketUpper.getVcCount() != 0 && server.getVNowCount() > socketUpper.getVcCount()) {
                return true;
            }
            if (socketUpper.getTotalCount() != 0 && server.getNowCount() > socketUpper.getTotalCount()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean clearAllSocketCache(String params) {
        List serviceInstances = this.discoveryClient.getInstances("SOCKET-SERVER");
        if (serviceInstances != null && !serviceInstances.isEmpty()) {
            for (ServiceInstance instance : serviceInstances) {
                URI uri = instance.getUri();
                if (uri == null) continue;
                this.restTemplate.getForObject(uri + "/socket/clearDevicesCache?params={1}", Boolean.class, new Object[]{params});
            }
        }
        return true;
    }

    @Override
    public List<Server> changeServerList(String param) {
        if (Objects.isNull(this.serverType)) {
            this.serverType = this.deliveryConfig.isServerType();
        }
        if (this.serverType.booleanValue()) {
            ArrayList<Server> servers = new ArrayList<Server>();
            String[] sockets = this.deliveryConfig.getSockets().split(",");
            if (sockets != null && sockets.length != 0) {
                for (String socket : sockets) {
                    Server server = (Server)this.restTemplate.getForObject(socket + "/socket/getServerParam?param={1}", Server.class, new Object[]{param});
                    if (server == null) continue;
                    servers.add(server);
                }
            }
            return servers;
        }
        return this.serverList(param);
    }

    @Override
    public boolean changeServerType(String key) {
        if ("consul".equalsIgnoreCase(key)) {
            this.serverType = false;
        } else if ("local".equalsIgnoreCase(key)) {
            this.serverType = true;
        } else {
            return false;
        }
        return true;
    }

    @Override
    public String getServerType() {
        if (this.serverType.booleanValue()) {
            return "local";
        }
        return "consul";
    }
}

