/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.sds.delivery.service.impl;

import com.codingapi.sds.delivery.service.AdminService;
import com.codingapi.sds.delivery.service.DeliveryServerSendEventService;
import com.codingapi.sds.delivery.service.DeliveryService;
import com.codingapi.sds.delivery.service.RedisService;
import com.codingapi.sds.delivery.utils.TelnetUtils;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class DeliveryServiceImpl
implements DeliveryService {
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RedisService redisService;
    @Autowired
    private DeliveryServerSendEventService deliveryServerSendEventService;
    @Autowired
    private AdminService adminService;
    private Logger logger = LoggerFactory.getLogger(DeliveryServiceImpl.class);

    @Override
    @Async(value="socketDelivery")
    public void delivery(ChannelHandlerContext ctx, Object msg) {
        this.deliveryServerSendEventService.onDeliveryListener(ctx, msg);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.deliveryServerSendEventService.onConnectionListener(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.deliveryServerSendEventService.onDisConnectionListener(ctx);
    }

    private ServiceInstance getInstance(String ipPort) {
        List instances = this.discoveryClient.getInstances("SOCKET-SERVER");
        for (ServiceInstance instance : instances) {
            String ip = instance.getHost();
            int port = instance.getPort();
            String instancesIpPort = String.format("%s:%d", ip, port);
            if (!instancesIpPort.equals(ipPort)) continue;
            return instance;
        }
        return null;
    }

    @Override
    public void checkSocket() {
        this.logger.info("check - socket server start ");
        List<String> onlines = this.adminService.models();
        for (String ipPort : onlines) {
            int port;
            String ip = ipPort.split(":")[0];
            boolean telnetState = TelnetUtils.telnet(ip, port = Integer.parseInt(ipPort.split(":")[1]));
            if (telnetState) {
                ServiceInstance serviceInstance;
                block10: {
                    serviceInstance = this.getInstance(ipPort);
                    if (serviceInstance == null) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        serviceInstance = this.getInstance(ipPort);
                    }
                    this.logger.info("ipPort -> " + ipPort + " serviceInstance->:" + serviceInstance);
                    if (serviceInstance == null) continue;
                    this.logger.info("check - server:" + ipPort + " start ");
                    try {
                        String resVal = (String)this.restTemplate.getForObject(serviceInstance.getUri() + "/socket/index", String.class, new Object[0]);
                        if ("success".equals(resVal)) break block10;
                        this.redisService.removeAll(ipPort);
                        this.logger.info("remove -> server:" + ipPort);
                    }
                    catch (Exception e) {
                        this.logger.error("error--> remove -> server:" + ipPort + ", exp->" + e.getMessage());
                        this.redisService.removeAll(ipPort);
                        continue;
                    }
                }
                Set<String> values = this.redisService.all(ipPort);
                for (String uniqueKey : values) {
                    this.logger.info("checkChannel -> server:" + ipPort + ",uniqueKey->" + uniqueKey + " start .");
                    try {
                        boolean res = (Boolean)this.restTemplate.postForObject(serviceInstance.getUri() + "/socket/checkChannel?uniqueKey={uniqueKey}", (Object)uniqueKey, Boolean.class, new Object[]{uniqueKey});
                        this.logger.info("checkChannel -> server:" + ipPort + ",uniqueKey->" + uniqueKey + " end . res->" + res);
                        if (res) continue;
                        this.redisService.remove(ipPort, uniqueKey);
                    }
                    catch (Exception e) {
                        this.logger.error("error--> remove checkChannel -> server:" + ipPort + ", exp->" + e.getMessage());
                        this.redisService.remove(ipPort, uniqueKey);
                    }
                }
                continue;
            }
            this.redisService.removeAll(ipPort);
        }
        this.logger.info("check - socket server end");
    }
}

