/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.sds.delivery.service.impl;

import com.codingapi.sds.delivery.service.DeliveryService;
import com.codingapi.sds.delivery.service.InitService;
import com.codingapi.sds.delivery.service.NettyServerService;
import com.codingapi.sds.delivery.service.SettingService;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitServiceImpl
implements InitService {
    @Autowired
    private NettyServerService nettyServerService;
    @Autowired
    private DeliveryService deliveryService;
    @Autowired
    private SettingService settingService;
    private Logger logger = LoggerFactory.getLogger(InitServiceImpl.class);
    private Timer timer = new Timer();
    private static final int defaultDelayTime = 10;

    @Override
    public void start() {
        this.nettyServerService.start();
        int checkTime = this.settingService.getCheckTime();
        if (checkTime <= 0) {
            checkTime = 10;
        }
        this.logger.info("init ->start,check time(min):" + checkTime);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    InitServiceImpl.this.deliveryService.checkSocket();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 10000L, (long)(checkTime * 60000));
    }

    @Override
    public void close() {
        this.timer.cancel();
        this.nettyServerService.close();
    }
}

