/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.sds.delivery.service.impl;

import com.codingapi.sds.delivery.service.DeliveryService;
import com.codingapi.sds.delivery.service.NettyServerService;
import com.codingapi.sds.delivery.service.SettingService;
import com.codingapi.sds.delivery.socket.DeliveryHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NettyServerServiceImpl
implements NettyServerService {
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ServerBootstrap b;
    @Autowired
    private SettingService settingService;
    private int heartTime = 5;
    @Autowired
    private DeliveryService deliveryService;
    private Logger logger = LoggerFactory.getLogger(NettyServerServiceImpl.class);

    @Override
    public synchronized void start() {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        try {
            this.b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)this.b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new ByteArrayDecoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{new ByteArrayEncoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4)});
                    ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler((long)NettyServerServiceImpl.this.heartTime, (long)NettyServerServiceImpl.this.heartTime, (long)NettyServerServiceImpl.this.heartTime, TimeUnit.SECONDS)});
                    ch.pipeline().addLast(new ChannelHandler[]{new DeliveryHandler(NettyServerServiceImpl.this.deliveryService)});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            this.b.bind(this.settingService.getDeliveryPort());
            this.logger.info("socket: " + this.settingService.getDeliveryPort() + " starting....");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void close() {
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        this.logger.info("socket closing....");
    }
}

