/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.sds.delivery.service.impl;

import com.codingapi.sds.delivery.model.SocketDeliveryParam;
import com.codingapi.sds.delivery.model.SocketModel;
import com.codingapi.sds.delivery.service.OnlineService;
import com.codingapi.sds.delivery.service.RedisService;
import com.lorne.core.framework.exception.ServiceException;
import com.ysscale.redis.service.RedisHandleService;
import com.ysscale.socket.vo.DeviceCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OnLineServiceImpl
implements OnlineService {
    @Autowired
    private RedisService redisService;
    @Autowired
    private RedisHandleService redisHandleService;

    @Override
    public boolean add(String modelName, String uniqueKey) {
        this.redisService.add(modelName, uniqueKey);
        return true;
    }

    @Override
    public boolean remove(String modelName, String uniqueKey) {
        this.redisService.remove(modelName, uniqueKey);
        return true;
    }

    @Override
    public boolean putKey(String modelName, String uniqueKey, String key) {
        this.redisService.putKey(modelName, uniqueKey, key);
        return true;
    }

    @Override
    public boolean check(String key) {
        String val = this.redisService.getModelByKey(key);
        return !StringUtils.isEmpty((CharSequence)val);
    }

    @Override
    public List<DeviceCheck> checks(String keys) {
        ArrayList<DeviceCheck> deviceChecks = new ArrayList<DeviceCheck>();
        String[] macs = keys.split(",");
        if (macs != null && macs.length != 0) {
            for (String mac : macs) {
                boolean res = false;
                String val = this.redisService.getModelByKey(mac);
                if (StringUtils.isNotBlank((CharSequence)val)) {
                    res = true;
                }
                deviceChecks.add(new DeviceCheck(mac, res));
            }
        }
        return deviceChecks;
    }

    @Override
    public boolean register(String serverId) {
        SocketDeliveryParam socketDeliveryParam = new SocketDeliveryParam(serverId, 0, 0);
        this.redisHandleService.addHashKey("DELIVERY", "UPPER", serverId, (Object)socketDeliveryParam);
        return true;
    }

    @Override
    public boolean addSocketUpper(SocketDeliveryParam socketDeliveryParam) {
        SocketDeliveryParam hashVal = (SocketDeliveryParam)this.redisHandleService.getHashVal("DELIVERY", "UPPER", socketDeliveryParam.getServerId());
        if (Objects.isNull(hashVal)) {
            this.redisHandleService.addHashKey("DELIVERY", "UPPER", socketDeliveryParam.getServerId(), (Object)socketDeliveryParam);
        }
        return true;
    }

    @Override
    public boolean delSocketUpper(String serverId) {
        this.redisHandleService.removeHashKey("DELIVERY", "UPPER", serverId);
        return true;
    }

    @Override
    public List getSocketUpper() {
        return this.redisHandleService.getHashValList("DELIVERY", "UPPER");
    }

    @Override
    public SocketDeliveryParam getSocketUpper(String serverId) {
        return (SocketDeliveryParam)this.redisHandleService.getHashVal("DELIVERY", "UPPER", serverId);
    }

    @Override
    public SocketModel getModelByKey(String key) throws ServiceException {
        String val = this.redisService.getModelByKey(key);
        if (StringUtils.isEmpty((CharSequence)val)) {
            throw new ServiceException("data not exist.");
        }
        String[] mv = val.split("#");
        SocketModel model = new SocketModel();
        model.setModelName(mv[0]);
        model.setUniqueKey(mv[1]);
        return model;
    }
}

