/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.sds.delivery.service.impl;

import com.codingapi.sds.delivery.service.RedisService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;

@Service
public class RedisServiceImpl
implements RedisService {
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public List<String> models() {
        return new ArrayList<String>(this.redisTemplate.keys((Object)"sds_*"));
    }

    @Override
    public Set<String> all(String key) {
        String mkey = "sds_" + key;
        return this.redisTemplate.opsForSet().members((Object)mkey);
    }

    @Override
    public void removeAll(String key) {
        String mkey = "sds_" + key;
        this.redisTemplate.delete((Object)mkey);
    }

    @Override
    public void remove(String key, String uniqueKey) {
        String mkey = "sds_" + key;
        this.redisTemplate.opsForSet().remove((Object)mkey, new Object[]{uniqueKey});
        this.removeKey(key, uniqueKey);
    }

    @Override
    public void add(String key, String value) {
        String mkey = "sds_" + key;
        this.redisTemplate.opsForSet().add((Object)mkey, (Object[])new String[]{value});
    }

    @Override
    public void putKey(String modelName, String uniqueKey, String key) {
        String val = modelName + "#" + uniqueKey;
        ValueOperations operations = this.redisTemplate.opsForValue();
        operations.set((Object)("skey_" + key), (Object)val);
        operations.set((Object)("sval_" + val), (Object)key);
    }

    @Override
    public void removeKey(String modelName, String uniqueKey) {
        String val = modelName + "#" + uniqueKey;
        String mkey = "sval_" + val;
        ValueOperations operations = this.redisTemplate.opsForValue();
        String key = (String)operations.get((Object)mkey);
        String mval = (String)operations.get((Object)("skey_" + key));
        if (val.equals(mval)) {
            this.redisTemplate.delete((Object)("skey_" + key));
        }
        this.redisTemplate.delete((Object)mkey);
    }

    @Override
    public String getModelByKey(String key) {
        ValueOperations operations = this.redisTemplate.opsForValue();
        return (String)operations.get((Object)("skey_" + key));
    }
}

