/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.sds.delivery.service.impl;

import com.codingapi.sds.delivery.config.DeliveryConfig;
import com.codingapi.sds.delivery.model.DeliveryModel;
import com.codingapi.sds.delivery.service.DeliveryServerService;
import com.codingapi.sds.delivery.service.RedisService;
import com.codingapi.sds.delivery.service.SettingService;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.stereotype.Service;

@Service
public class SettingServiceImpl
implements SettingService {
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private RedisService redisService;
    @Autowired
    private Registration registration;
    @Autowired
    private DeliveryConfig deliveryConfig;
    @Autowired
    private DeliveryServerService deliveryServerService;

    @Override
    public String getDeliveryIp() {
        return this.registration.getHost();
    }

    @Override
    public int getDeliveryPort() {
        return this.deliveryConfig.getPort();
    }

    @Override
    public boolean testRedis() {
        this.redisService.models();
        return true;
    }

    private boolean isIp(String ipAddress) {
        String ip = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pattern = Pattern.compile(ip);
        Matcher matcher = pattern.matcher(ipAddress);
        return matcher.matches();
    }

    private List<String> getServices(String key) {
        ArrayList<String> urls = new ArrayList<String>();
        List serviceInstances = this.discoveryClient.getInstances(key);
        for (ServiceInstance instanceInfo : serviceInstances) {
            String url = instanceInfo.getUri().toString();
            String address = instanceInfo.getHost();
            if (this.isIp(address)) {
                urls.add(url);
                continue;
            }
            url = url.replace(address, "127.0.0.1");
            urls.add(url);
        }
        return urls;
    }

    @Override
    public DeliveryModel loadSetting() {
        DeliveryModel model = new DeliveryModel();
        model.setIp(this.getDeliveryIp());
        model.setPort(this.getDeliveryPort());
        model.setType(this.deliveryServerService.getServerType());
        model.setTestRedis(this.testRedis());
        model.setDeliverys(this.getServices("delivery"));
        model.setSockets(this.getServices("socket-server"));
        return model;
    }

    @Override
    public int getCheckTime() {
        return this.deliveryConfig.getCheckTime();
    }
}

