/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.sds.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.sds.delivery.model.SocketModel;
import com.codingapi.sds.delivery.service.OnlineService;
import com.codingapi.sds.delivery.service.SocketService;
import com.lorne.core.framework.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SocketServiceImpl
implements SocketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private OnlineService onlineService;

    @Override
    @Async(value="cmdSendDelivery")
    public void ansySendHexCmd(String modelName, String uniqueKey, String cmd) {
        String url = "http://" + modelName + "/socket/sendHexCmd";
        LOGGER.info("sendHexCmd: url[" + url + "-" + uniqueKey + "]; CMD[" + cmd + "]");
        JSONObject msg = new JSONObject();
        msg.put("uniqueKey", (Object)uniqueKey);
        msg.put("cmd", (Object)cmd);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)msg.toJSONString(), (MultiValueMap)headers);
        this.restTemplate.postForObject(url, (Object)request, Boolean.class, new Object[0]);
    }

    @Override
    public boolean sendHexCmd(String modelName, String uniqueKey, String cmd) throws ServiceException {
        this.ansySendHexCmd(modelName, uniqueKey, cmd);
        return true;
    }

    @Override
    public boolean sendHexCmdByKey(String key, String cmd) throws ServiceException {
        SocketModel socketModel = this.onlineService.getModelByKey(key);
        return this.sendHexCmd(socketModel.getModelName(), socketModel.getUniqueKey(), cmd);
    }

    @Override
    public boolean sendBase64Cmd(String modelName, String uniqueKey, String cmd) throws ServiceException {
        String url = "http://" + modelName + "/socket/sendBase64Cmd";
        return (Boolean)this.restTemplate.postForObject(url + "?uniqueKey={uniqueKey}&cmd={cmd}", null, Boolean.class, new Object[]{uniqueKey, cmd});
    }

    @Override
    public boolean sendStrCmd(String modelName, String uniqueKey, String cmd) throws ServiceException {
        String url = "http://" + modelName + "/socket/sendStrCmd";
        return (Boolean)this.restTemplate.postForObject(url + "?uniqueKey={uniqueKey}&cmd={cmd}", null, Boolean.class, new Object[]{uniqueKey, cmd});
    }

    @Override
    public SocketModel getServerByKey(String key) throws ServiceException {
        SocketModel socketModel = this.onlineService.getModelByKey(key);
        return socketModel;
    }

    @Override
    public boolean sendBase64CmdByKey(String key, String cmd) throws ServiceException {
        SocketModel socketModel = this.onlineService.getModelByKey(key);
        return this.sendBase64Cmd(socketModel.getModelName(), socketModel.getUniqueKey(), cmd);
    }

    @Override
    public boolean sendStrCmdByKey(String key, String cmd) throws ServiceException {
        SocketModel socketModel = this.onlineService.getModelByKey(key);
        return this.sendStrCmd(socketModel.getModelName(), socketModel.getUniqueKey(), cmd);
    }
}

