package com.ysscale.socket.service.impl;

import com.ysscale.socket.service.DeliveryServerService;
import com.ysscale.socket.utils.ListUtil;
import com.ysscale.socket.vo.ServerWebSocket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

/**
 * @author lie_w
 * @title: DeliveryServerServiceImpl
 * @projectName socket
 * @description: TODO
 * @date 2019/5/230:10
 */
@Service
public class DeliveryServerServiceImpl implements DeliveryServerService {

    @Autowired
    private DiscoveryClient discoveryClient;

    @Autowired
    private RestTemplate restTemplate;

    @Override
    public List<ServerWebSocket> getSocketList(String serverId) {
        List<ServiceInstance> instances = discoveryClient.getInstances(serverId);
        List<ServerWebSocket> servers = new ArrayList<>();
        if (instances != null && !instances.isEmpty()) {
            for (ServiceInstance instance : instances) {
                URI uri = instance.getUri();
                if (uri != null) {
                    ServerWebSocket webSocket = restTemplate.getForObject(uri + "/webSocket/getWebServer", ServerWebSocket.class);
                    if (webSocket != null && webSocket.getNowCount() < webSocket.getMaxCount()) {
                        servers.add(webSocket);
                    }
                }
            }
        }
        return servers;
    }

    @Override
    public ServerWebSocket selectSocket(String serverId) {
        List<ServerWebSocket> socketList = getSocketList(serverId);
        if (socketList != null && !socketList.isEmpty()) {
            ListUtil.sort(socketList, true, "nowCount");
            return socketList.get(0);
        }
        return null;
    }

}
