package com.codingapi.sso.client.api.Hystrix;


import com.codingapi.netflix.framework.Constants;
import com.codingapi.netflix.framework.exception.ServerFeignException;
import com.codingapi.sso.client.api.SSOTokenClient;
import com.codingapi.sso.client.ato.vo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * @author lorne
 * @date 2018/4/4
 * @description
 */
@Component
public class SSOTokenClientHystrix implements SSOTokenClient {


    private Logger logger = LoggerFactory.getLogger(SSOTokenClientHystrix.class);


    @Override
    public LoginTokenReq login(LoginReq loginReq) throws ServerFeignException {
        logger.error("远程调用SSO失败 >>>>>>>>> 用户登录获取token ");
        throw  new ServerFeignException( Constants.GLOBAL_EXCEPTION_SSO_TOKEN_LOGIN ,"SSO_用户登录失败！");
    }


    @Override
    public SSOUser verify(String token) throws ServerFeignException {
        logger.error("远程调用SSO失败 >>>>>>>>> 通过token获取用户信息 ");
        throw  new ServerFeignException( Constants.GLOBAL_EXCEPTION_SSO_TOKEN_VERIFY ,"SSO_获取用户信息失败！");
    }


    @Override
    public int reload(ReloadReq reloadReq) throws ServerFeignException {
        logger.error("远程调用SSO失败 >>>>>>>>> 加载延迟token值存储时间异常 ");
        throw  new ServerFeignException( Constants.GLOBAL_EXCEPTION_SSO_TOKEN_RELOAD ,"SSO_用户信息延时失败！");
    }

    @Override
    public int clear(ReloadReq reloadReq) throws ServerFeignException {
        logger.error("远程调用SSO失败 >>>>>>>>> 清除用户信息失败！ ");
        throw  new ServerFeignException( Constants.GLOBAL_EXCEPTION_SSO_TOKEN_RELOAD ,"SSO_清除用户信息失败！");
    }

}
