package com.codingapi.sso.client.api.Hystrix;


import com.codingapi.netflix.framework.Constants;
import com.codingapi.netflix.framework.exception.ServerFeignException;
import com.codingapi.sso.client.api.SSOUserClient;
import com.codingapi.sso.client.ato.vo.RegisterReq;
import com.codingapi.sso.client.ato.vo.UserRemoveReq;
import com.codingapi.sso.client.ato.vo.UserUpdateReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * @author lorne
 * @date 2018/4/4
 * @description
 */
@Component
public class SSOUserClientHystrix implements SSOUserClient {


    private Logger logger = LoggerFactory.getLogger(SSOUserClientHystrix.class);


    @Override
    public int register(RegisterReq registerReq) throws ServerFeignException {
        logger.error("远程调用SSO失败 >>>>>>>>> 注册单点登录用户 ");
        throw  new ServerFeignException( Constants.GLOBAL_EXCEPTION_SSO_USER_REGISTER ,"SSO_用户注册失败！");
    }

    @Override
    public int updateUser(UserUpdateReq userUpdateReq) throws ServerFeignException {
        logger.error("远程调用SSO失败 >>>>>>>>> 更新单点登录用户信息 ");
        throw  new ServerFeignException( Constants.GLOBAL_EXCEPTION_SSO_USER_UPDATEUSER ,"SSO_用户信息更新失败！");
    }

    @Override
    public int removeUser(UserRemoveReq urr) throws ServerFeignException {
        logger.error("远程调用SSO失败 >>>>>>>>> 删除单点登录用户信息 ");
        throw  new ServerFeignException( Constants.GLOBAL_EXCEPTION_SSO_USER_REMOVEUSER ,"SSO_用户信息删除失败！");
    }
}
