package com.codingapi.sso.client.api;

import com.codingapi.netflix.framework.exception.ServerFeignException;
import com.codingapi.sso.client.api.Hystrix.SSOTokenClientHystrix;
import com.codingapi.sso.client.api.Hystrix.SSOUserClientHystrix;
import com.codingapi.sso.client.ato.vo.LoginReq;
import com.codingapi.sso.client.ato.vo.LoginTokenReq;
import com.codingapi.sso.client.ato.vo.ReloadReq;
import com.codingapi.sso.client.ato.vo.SSOUser;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author 侯存路
 * @date 2018/4/19
 * @company codingApi
 * @description
 */
@FeignClient(value = "server-sso"  , fallback = SSOTokenClientHystrix.class)
public interface SSOTokenClient {


    /**
     * 用户登录获取token
     * @param loginReq
     * @return
     */
    @RequestMapping(value = "/token/login", method = RequestMethod.POST)
    LoginTokenReq login(@RequestBody LoginReq loginReq) throws ServerFeignException;



    /**
     * 通过token获取用户信息
     * @param token
     * @return
     */
    @RequestMapping(value = "/token/verify", method = RequestMethod.POST)
    SSOUser verify(@RequestParam("token") String token) throws ServerFeignException;



    /**
     * 加载延迟token值存储时间
     * @param reloadReq
     * @return
     */
    @RequestMapping(value = "/token/reload", method = RequestMethod.POST)
    int reload(@RequestBody ReloadReq reloadReq) throws ServerFeignException;


    /**
     * 清除用户信息
     * @param reloadReq
     * @return
     */
    @RequestMapping(value = "/token/clear", method = RequestMethod.POST)
    int clear(@RequestBody ReloadReq reloadReq) throws ServerFeignException;


}
