package com.codingapi.sso.client.api;

import com.codingapi.netflix.framework.exception.ServerFeignException;
import com.codingapi.sso.client.api.Hystrix.SSOUserClientHystrix;
import com.codingapi.sso.client.ato.vo.RegisterReq;
import com.codingapi.sso.client.ato.vo.UserRemoveReq;
import com.codingapi.sso.client.ato.vo.UserUpdateReq;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author 侯存路
 * @date 2018/4/19
 * @company codingApi
 * @description
 */
@FeignClient(value = "server-sso" , fallback = SSOUserClientHystrix.class )
public interface SSOUserClient {


    /**
     * 注册单点登录用户
     * @param registerReq
     * @return
     */
    @RequestMapping(value = "/user/register",method = RequestMethod.POST)
    int register(@RequestBody RegisterReq registerReq) throws ServerFeignException;


    /**
     * 更新单点登录用户信息
     * @param userUpdateReq
     * @return
     */
    @RequestMapping(value = "/user/updateUser",method = RequestMethod.POST)
    int updateUser(@RequestBody UserUpdateReq userUpdateReq) throws ServerFeignException;


    /**
     * 删除单点登录用户信息
     * @param urr
     * @return
     */
    @RequestMapping(value = "/user/removeUser",method = RequestMethod.POST)
    int removeUser(@RequestBody UserRemoveReq urr) throws ServerFeignException;

}
