package com.jhscale.common.ai;

import com.jhscale.common.model.simple.JSONModel;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title: FeatureParam
 * @description: TODO
 * @date 2025/5/21 10:13
 */
public class JFeatureParam extends JSONModel {

    // 图片压缩尺寸大小 默认224
    private int width;
    private int height;

    private int ftc;// 特征数量

    // 数据预处理 均值和标准差
    private float[] mean;
    private float[] std;

    private int[] image_area;// 图片裁剪区间

    private String[] label_names;// 标签信息

    private JLabel[] labels;// 标签与名称

    private Map<String, JLabel> labelMap;// 标签与名称 Map

    private String version;// 模型版本

    /**
     * @description: Label Map
     * @date: 2025-05-22 10:34:17
     **/
    public Map<String, JLabel> labelMap() {
        Map<String, JLabel> labelMap = new HashMap<>();
        if (labels != null) {
            for (JLabel label : labels) {
                labelMap.put(label.getLabel_name(), label);
            }
        }
        return labelMap;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getFtc() {
        return ftc;
    }

    public void setFtc(int ftc) {
        this.ftc = ftc;
    }

    public float[] getMean() {
        return mean;
    }

    public void setMean(float[] mean) {
        this.mean = mean;
    }

    public float[] getStd() {
        return std;
    }

    public void setStd(float[] std) {
        this.std = std;
    }

    public int[] getImage_area() {
        return image_area;
    }

    public void setImage_area(int[] image_area) {
        this.image_area = image_area;
    }

    public String[] getLabel_names() {
        return label_names;
    }

    public void setLabel_names(String[] label_names) {
        this.label_names = label_names;
    }

    public JLabel[] getLabels() {
        return labels;
    }

    public void setLabels(JLabel[] labels) {
        this.labels = labels;
    }

    public Map<String, JLabel> getLabelMap() {
        return labelMap;
    }

    public void setLabelMap(Map<String, JLabel> labelMap) {
        this.labelMap = labelMap;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return "JFeatureParam{" +
                "width=" + width +
                ", height=" + height +
                ", ftc=" + ftc +
                ", mean=" + Arrays.toString(mean) +
                ", std=" + Arrays.toString(std) +
                ", image_area=" + Arrays.toString(image_area) +
                ", label_names=" + Arrays.toString(label_names) +
                ", labels=" + Arrays.toString(labels) +
                ", version='" + version + '\'' +
                '}';
    }
}
