package com.jhscale.common.ai;

import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title: Label
 * @description: TODO
 * @date 2025/5/21 10:21
 */
public class JLabel extends JSONModel {

    // 标签编号AI模型编号
    private String label_name;
    // 标签名称
    private String nick_name;

    public JLabel() {
    }

    public JLabel(String label_name, String nick_name) {
        this.label_name = label_name;
        this.nick_name = nick_name;
    }

    public JLabel(String label_str) {
        try {
            String[] s = label_str.split("_");
            this.label_name = s[0];
            this.nick_name = s[1];
        } catch (Exception e) {
            System.err.printf("Label_Str: %s%n", label_str);
        }
    }

    /**
     * @description: 标签名
     **/
    public String label_str() {
        return StringUtils.isNotBlank(this.label_name) && StringUtils.isNotBlank(this.nick_name) ?
                String.format("%s_%s", this.getLabel_name(), this.getNick_name())
                : DateUtils.getDate_YYMMDD(new Date());
    }

    public String getLabel_name() {
        return StringUtils.isBlank(this.label_name) ? this.nick_name : this.label_name;
    }

    public void setLabel_name(String label_name) {
        this.label_name = label_name;
    }

    public String getNick_name() {
        return StringUtils.isBlank(this.nick_name) ? this.label_name : this.nick_name;
    }

    public void setNick_name(String nick_name) {
        this.nick_name = nick_name;
    }

    @Override
    public String toString() {
        return "JLabel{" +
                "label_name='" + label_name + '\'' +
                ", nick_name='" + nick_name + '\'' +
                '}';
    }
}
