package com.jhscale.common.ai;

import com.jhscale.common.model.inter.GJSONModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

/**
 * @author wang lie
 */
public class ProbablyScore implements GJSONModel, Comparable<ProbablyScore> {

    @ApiModelProperty(value = "结果序号", name = "id")
    private int id;

    @ApiModelProperty(value = "结果", name = "source")
    private float source;

    @ApiModelProperty(value = "训练标签", name = "imageName")
    private String imageName;

    @ApiModelProperty(value = "身份编号", name = "model")
    private String model;

    @ApiModelProperty(value = "简写", name = "simple")
    private String simple;

    @ApiModelProperty(value = "标签名称信息", name = "label")
    private JLabel label;

    public ProbablyScore() {
    }

    public ProbablyScore(int id, float source, String imageName) {
        this.id = id;
        this.source = source;
        this.imageName = imageName;
        if (StringUtils.isNotBlank(imageName) && imageName.contains("@")) {
            String[] split = imageName.split("@");
            this.model = split[0];
            this.simple = split[1];
        }
    }

    @Override
    public int compareTo(ProbablyScore o) {
        return Float.compare(o.getSource(), this.source);
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public float getSource() {
        return source;
    }

    public void setSource(float source) {
        this.source = source;
    }

    public String getImageName() {
        return imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getSimple() {
        return simple;
    }

    public void setSimple(String simple) {
        this.simple = simple;
    }

    public JLabel getLabel() {
        return label;
    }

    public void setLabel(JLabel label) {
        this.label = label;
    }
}
