package com.jhscale.common.annotation;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;

import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: BigDecimalToDouble
 * @projectName common
 * @description: @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
 * @date 2022/8/1517:06
 */
public class BigDecimalToDouble implements ObjectSerializer {
    @Override
    public void write(JSONSerializer jsonSerializer, Object o, Object o1, Type type, int i) throws IOException {
        BigDecimal value = (BigDecimal) o;
        Double doubleValue = value.doubleValue();
        jsonSerializer.write(doubleValue);
    }
}
