package com.jhscale.common.annotation;

import java.lang.annotation.*;

import static com.jhscale.common.model.device.DConstant.PUBLIC_FIELD_SPLIT;
import static com.jhscale.common.model.device.DConstant.PUBLIC_LINE_SPLIT;

/**
 * @author lie_w
 * @title: PLUClass
 * @projectName common
 * @description: TODO
 * @date 2022/12/3012:55
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface DataClass {

    /**
     * @description: 标志
     **/
    String mark() default "";

    /**
     * @description: 是否支持事件
     **/
    boolean ask() default false;

    /**
     * @description: 字段分隔符
     **/
    String separator() default PUBLIC_FIELD_SPLIT;

    /**
     * @description: 行分隔符
     **/
    String line() default PUBLIC_LINE_SPLIT;

    /**
     * @description: 忽略 @PublicField
     **/
    String ignorePublicField() default "";

    /**
     * @description: 日志打印
     **/
    boolean print() default false;

    /**
     * @description: 版本序列号
     **/
    int serial() default 0;
}
