package com.jhscale.common.annotation;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;

import java.lang.reflect.Type;
import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: BigDecimalToDouble
 * @projectName common
 * @description: @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
 * @date 2022/8/1517:06
 */
public class DoubleToBigDecimal implements ObjectDeserializer {

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object o) {
        Double value = defaultJSONParser.parseObject(Double.class);
        return (T) new BigDecimal(value);
    }

    @Override
    public int getFastMatchToken() {
        return 0;
    }
}
