package com.jhscale.common.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author lie_w
 * @title: IgnoreField
 * @projectName common
 * @description: TODO
 * @date 2022/3/3010:30
 */
@Target({ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface FieldName {

    /**
     * @description: 分组编号
     **/
    int group() default 0;

    /**
     * @description: 排序编号
     **/
    int sort() default 0;

    /**
     * @description: 国际化标识
     **/
    String jsl() default "";

    /**
     * @description: 名称
     **/
    String name() default "";

    /**
     * @description: 标题
     **/
    boolean title() default false;
}
