package com.jhscale.common.annotation;

import com.jhscale.common.model.simple.FieldModel;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import static com.jhscale.common.model.device.DConstant.PUBLIC_KV_SET_FIELD_SPLIT;
import static com.jhscale.common.model.device.DConstant.PUBLIC_SET_FIELD_SPLIT;

/**
 * @author lie_w
 * @title: PLUClass
 * @projectName common
 * @description: 公开协议字段
 * @date 2022/12/3012:55
 */
@Target({ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface PublicField {

    /**
     * @description: 序号
     **/
    int index() default 0;

    /**
     * @description: 数据类型
     * 1-时间
     **/
    int type() default 0;

    /**
     * @description: 默认值
     **/
    String defaultVal() default "";

    /**
     * @description: FieldModel 对象数据类型Class
     **/
    Class field_class() default FieldModel.class;

    /**
     * @description: FieldModel 长度
     **/
    int field_length() default 1;

    /**
     * @description: LIST 数据类型
     **/
    int list_type() default 0;

    /**
     * @description: List 数据Class
     **/
    Class list_class() default FieldModel.class;


    /**
     * @description: MAP Key 数据类型
     **/
    int map_key_type() default 0;

    /**
     * @description: MAP Key 数据Class
     **/
    Class map_key_class() default String.class;

    /**
     * @description: MAP Val 数据类型
     **/
    int map_val_type() default 0;

    /**
     * @description: MAP Val 数据Class
     **/
    Class map_val_class() default FieldModel.class;


    /**
     * @description: 集合分隔符
     **/
    String set_split() default PUBLIC_SET_FIELD_SPLIT;

    /**
     * @description: Map Key Val 分隔符
     **/
    String set_kv_split() default PUBLIC_KV_SET_FIELD_SPLIT;
}
