package com.jhscale.common.annotation;

import com.jhscale.common.model.simple.FieldModel;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author lie_w
 * @title: PLUClass
 * @projectName common
 * @description: 服务隐私协议字段
 * @date 2022/12/3012:55
 */
@Target({ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ServerField {

    /**
     * @description: 序号
     **/
    int index() default 0;

    /**
     * @description: 长度
     **/
    int length() default 0;

    /**
     * @description: 数据类型
     * 1-时间
     **/
    int type() default 0;

    /**
     * @description: 必填数值
     **/
    boolean must() default false;

    /**
     * @description: FieldModel 对象数据类型Class
     **/
    Class field_class() default FieldModel.class;

    /**
     * @description: LIST 数据类型
     **/
    int list_type() default 0;

    /**
     * @description: List 数据Class
     **/
    Class list_class() default FieldModel.class;

    /**
     * @description: MAP Key 数据类型
     **/
    int map_key_type() default 0;

    /**
     * @description: MAP Key 数据Class
     **/
    Class map_key_class() default String.class;

    /**
     * @description: MAP Val 数据类型
     **/
    int map_val_type() default 0;

    /**
     * @description: MAP Val 数据Class
     **/
    Class map_val_class() default FieldModel.class;
}
