package com.jhscale.common.c;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title CMath
 * @description C Math算法
 * @create 2023/8/4 14:08
 */
public class CMath {

    static {
        System.loadLibrary("CMath");
    }

    /**
     * @description: 欧几里得距离 欧式距离
     * 欧几里得距离(Euclidean Distance)：计算两个向量之间的欧几里得距离，即两点之间的直线距离。
     * 公式：d = sqrt((x2 - x1)^2 + (y2 - y1)^2)
     **/
    public static native float calculate0(float[] f1, float[] f2);

    /**
     * @description: 曼哈顿距离
     * 曼哈顿距离(Manhattan Distance)：计算两个向量之间的曼哈顿距离，即两点之间的城市街区距离。
     * 公式：d = |x2 - x1| + |y2 - y1|
     **/
    public static native float calculate1(float[] f1, float[] f2);

    /**
     * @description: 切比雪夫距离
     * 切比雪夫距离(Chebyshev Distance)：计算两个向量之间的切比雪夫距离，即两点之间的棋盘距离。
     * 公式：d = max(|x2 - x1|, |y2 - y1|)
     **/
    public static native float calculate2(float[] f1, float[] f2);

    /**
     * @description: 余弦相似度
     * 余弦相似度(Cosine Similarity)：计算两个向量之间的余弦相似度，即两个向量的夹角的余弦值。
     * 公式：cosθ = A·B / (||A|| ||B||)
     **/
    public static native float calculate3(float[] f1, float[] f2);

    /**
     * @description: 皮尔逊相关系数
     * 皮尔逊相关系数(Pearson Correlation Coefficient)：计算两个向量之间的皮尔逊相关系数，即两个向量之间的线性相关性。
     * 公式：r = (nΣxy - ΣxΣy) / sqrt((nΣx^2 - (Σx)^2)(nΣy^2 - (Σy)^2))
     **/
    public static native float calculate4(float[] f1, float[] f2);

    /**
     * @description: 单元测试
     **/
    public static native int test(int arg);
}
