package com.jhscale.common.content;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

/**
 * @author lie_w
 * @title: JHContents
 * @projectName common
 * @description: TODO
 * @date 2020-11-068:11
 */
public interface JHContents {

    String SUCCESS = "SUCCESS";

    String FAIL = "FAIL";

    String INVENT_CODE = "00000000";

    String DEFAULT_CURRENCY_SYMBOL = "￥";

    Integer DEFAULT_CURRENCY_POINT = 2;

    /**
     * @description: 服务器语言国际化前缀
     **/
    String INTERNATIONAL_PREFIX = "JSL-";
    String SIGN_INTERNATIONAL_PREFIX = INTERNATIONAL_PREFIX + "sign";
    String PAYCODE_INTERNATIONAL_PREFIX = INTERNATIONAL_PREFIX + "paycode";

    /**
     * 系统默认语言
     */
    String SYS_DEFAUL_LANGUAGE = "zh-CHS";
    String COMPANY = "JHScale";
    String DEFAUL_COMPANY = "JHScale 1.0";

    /**
     * 翻译丢失
     */
    String LANGUAGE_LOST = "Translation Lost";

    /**
     * @description: 系统标志
     **/
    // Windows标志
    String WIN_SGIN = "win";

    // Linux标志
    String LINUX_SGIN = "linux";

    /**
     * HTTP请求
     */
    String HTTP = "http://";
    String HTTPS = "https://";
    String HTTP_U = "http";
    String HTTPS_U = "https";

    /**
     * 默认操作员编号
     */
    Long DEFAULT_INVENT_CODE = Long.parseLong("100000000000");

    /**
     * 默认超管角色
     */
    Integer DEFAULT_ADMIN_ROLE = 0;

    /**
     * 通用请求方式
     */
    String GENERAL_METHOD = "ANY";

    /**
     * 上下文标识
     */
    String CONTENT_PATH = "contextPath";

    /**
     * 翻译
     */
    Integer NO_INTERNATIONAL = 0;
    Integer INTERNATIONAL = 1;

    /**
     * 请求响应类型
     */
    Integer TYPE_HTML = 0;
    Integer TYPE_JSON = 1;
    Integer TYPE_XML = 2;
    Integer TYPE_BYTE = 3;

    String LOCAL_HOST = "localhost";

    Charset UTF_8 = StandardCharsets.UTF_8;
    Charset GBK = Charset.forName("GBK");
    String DEFAULT_SPLIT = "&&";

    /**
     * @description: 异常级别
     **/
    String PROFESSIONAL = "Professional";
    String TECHNOLOGY = "Technology";
    String WARNING = "Warning";

    String INFO = "INFO";
    String DEBUG = "DEBUG";
    String WARN = "WARN";
    String ERROR = "ERROR";

    BigDecimal ZERO = new BigDecimal("0");
    BigDecimal _ONE = new BigDecimal("-1");
    BigDecimal ONE = new BigDecimal("1");
    BigDecimal TEN = new BigDecimal("10");
    BigDecimal MULTIPLE = new BigDecimal("10000");

    /**
     * @description: Redis 目录
     **/
    String REDIS_DIR = ":";

    /**
     * @description: 默认部门 组 编号
     **/
    Integer DEFAULT_DEPT = 9;
    Integer DEFAULT_CATEGORY = 9;
    String DEFAULT_DEPT_Str = String.valueOf(DEFAULT_DEPT);
    String DEFAULT_CATEGORY_Str = String.valueOf(DEFAULT_CATEGORY);
    String DEFAULT_DEPT_NAME = "DEFAULT_D";
    String DEFAULT_CATEGORY_NAME = "DEFAULT_C";

    /**
     * @description: 未知文件格式
     **/
    String UN_KNOW_FILE_TYPE = ".jh";
    String OSS_Separator = "/";
    String File_Type_Split = ".";

    String ASC = "ASC";// 升序
    String DESC = "DESC";// 降序

    int AI_Algorithm_Type_Feature = 1;// 特征算法
    int AI_Algorithm_Type_Feature_1 = 5;// 特征算法
    int AI_Algorithm_Type_Label = 2;// 标签算法
    int AI_Algorithm_Type_Label_1 = 6;// 特征算法
    int AI_Algorithm_Type_Recognize = 3;// 物体检测算法
    int AI_Algorithm_Type_OpenCV = 4;// OpenCV物体检测
    int AI_Algorithm_Type_Detector_Feature = 7;// 目标检测+特征提取 算法

    String OSS_PUBLIC_BUCKName = "jh-up";
    String OSS_Server_BUCKName = "jh-load";
    String OSS_Owned_BUCKName = "jh-load";

    long HEX_MAX_4_Bit = Long.parseLong("FFFFFFFF", 16);

    String TOP = "02";
    String END = "03";
}
