package com.jhscale.common.em;

import com.jhscale.common.utils.ByteUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: BarcodeScale
 * @projectName common
 * @description: TODO
 * @date 2023/1/1022:14
 */
public enum BarcodeScale {

    KA(1, 7, "KA", 63, "08版本条码打印秤", "08's Bar Code Printing Scale"),
    KAB(2, 0, "KAB", 63, "12/15/17版本条码打印秤(带立杆)", "12's/15's/17's Bar Code Printing Scale(Pole)"),
    KAD(3, 1, "KAD", 40, "12/15版本条码打印秤(无立杆)", "12's/15's Bar Code Printing Scale(No Pole)"),
    KB(4, 2, "KB", 30, "价格标签秤(打印型)", "Price Printing Scale"),
    KC(5, 3, "KC", 40, "11/15/19版本价格标签秤(收银型)", "11's/15's/19's Cash Register Scale"),
    KCB(6, 8, "KCB", 60, "20版本价格标签秤(收银型)", "20's Cash Register Scale"),
    KD(7, 4, "KD", 30, "收银机", "Cash Register"),
    KE(8, 5, "KE", 10, "A1仪表", "A1 Indicator"),
    KF(9, 6, "KF", 40, "A1+/A2仪表", "A1+/A2 Indicator");

    // C定义编号
    private int board;

    // 前端定义编号
    private int ftBoard;

    private String simName;

    private int size;

    private String chineseName;

    private String englishName;

    BarcodeScale(int board, int ftBoard, String simName, int size, String chineseName, String englishName) {
        this.board = board;
        this.ftBoard = ftBoard;
        this.simName = simName;
        this.size = size;
        this.chineseName = chineseName;
        this.englishName = englishName;
    }

    /**
     * @description: 获取条码秤信息
     **/
    public static BarcodeScale board(Integer board) {
        if (Objects.nonNull(board)) {
            for (BarcodeScale barcodeScale : BarcodeScale.values()) {
                if (board.equals(barcodeScale.getBoard())) return barcodeScale;
            }
        }
        return BarcodeScale.KA;
    }

    /**
     * @description: 获取条码秤信息
     **/
    public static BarcodeScale ftBoard(Integer ftBoard) {
        if (Objects.nonNull(ftBoard)) {
            for (BarcodeScale barcodeScale : BarcodeScale.values()) {
                if (ftBoard.equals(barcodeScale.getFtBoard())) return barcodeScale;
            }
        }
        return BarcodeScale.KA;
    }

    public int getBoard() {
        return board;
    }

    public String getSimName() {
        return simName;
    }

    public int getFtBoard() {
        return ftBoard;
    }

    public int getSize() {
        return size;
    }

    public String getChineseName() {
        return chineseName;
    }

    public String getEnglishName() {
        return englishName;
    }

    /**
     * @description: 序号 从 1 开始 index 转 page_index
     **/
    public int[] order2PageIndex(int order) {
        try {
            String hex = ByteUtils.appendFill(Integer.toHexString(order), 4);
            return new int[]{Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16)};
        } catch (Exception e) {
            return new int[2];
        }
    }

    /**
     * @description: page_index 转 index
     **/
    public int pageIndex2Order(int page, int index) {
        try {
            String hex = ByteUtils.appendFill(Integer.toHexString(page), 2) + ByteUtils.appendFill(Integer.toHexString(index), 2);
            return Integer.parseInt(hex, 16);
        } catch (Exception e) {
            return 0;
        }
    }
}
