package com.jhscale.common.em;

import com.jhscale.common.content.JHContents;
import org.apache.commons.lang3.StringUtils;

public enum BizResult {

    失败(0, false, JHContents.FAIL, "失败"),
    成功(1, true, JHContents.SUCCESS, "成功"),
    ;

    private final int code;

    private final boolean result;

    private final String simple;

    private final String description;

    BizResult(int code, boolean result, String simple, String description) {
        this.code = code;
        this.result = result;
        this.simple = simple;
        this.description = description;
    }

    public static BizResult code(int code) {
        for (BizResult value : BizResult.values()) {
            if (value.code == code) return value;
        }
        return BizResult.失败;
    }

    public static BizResult simple(String simple) {
        if (StringUtils.isNotBlank(simple)) {
            for (BizResult value : BizResult.values()) {
                if (value.simple.equals(simple)) return value;
            }
        }
        return BizResult.失败;
    }

    public int getCode() {
        return code;
    }

    public boolean isResult() {
        return result;
    }

    public String getSimple() {
        return simple;
    }

    public String getDescription() {
        return description;
    }
}
