package com.jhscale.common.em;

import java.util.Objects;

/**
 * @author lie_w
 * @title: DataOperate
 * @projectName common
 * @description: TODO
 * @date 2022/10/1011:59
 */
public enum DataOperate {

    Add(0, "新增"),
    Update(1, "更新"),
    Delete(2, "删除"),;

    private Integer operate;

    private String description;

    DataOperate(Integer operate, String description) {
        this.operate = operate;
        this.description = description;
    }

    public static DataOperate operate(Integer operate) {
        if (Objects.nonNull(operate)) {
            for (DataOperate dataOperate : DataOperate.values()) {
                if (operate.equals(dataOperate.getOperate())) return dataOperate;
            }
        }
        return DataOperate.Add;
    }

    public Integer getOperate() {
        return operate;
    }

    public void setOperate(Integer operate) {
        this.operate = operate;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
