package com.jhscale.common.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title: DataState
 * @description: TODO
 * @date 2025/5/10 15:40
 */
public enum DataState {

    NORMAL(0, true),
    ABNORMAL(1, false);

    private final int state;

    private final boolean bl;

    DataState(int state, boolean bl) {
        this.state = state;
        this.bl = bl;
    }

    public static DataState state(String state) {
        if (StringUtils.isNotBlank(state)) {
            for (DataState value : DataState.values()) {
                if (state.equals(String.valueOf(value.state))) return value;
            }
        }
        return DataState.ABNORMAL;
    }

    public static DataState state(Integer state) {
        if (Objects.nonNull(state)) {
            for (DataState value : DataState.values()) {
                if (state.equals(value.state)) return value;
            }
        }
        return DataState.ABNORMAL;
    }

    public int getState() {
        return state;
    }

    public boolean isBl() {
        return bl;
    }
}
