package com.jhscale.common.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: DeviceType 0~65535
 * @projectName common
 * @description: TODO
 * @date 2020-12-039:21
 */
public enum DeviceType {

    Simple_Scales("Simple_Scales", "普通收银秤", "D-info", 0, ZuulDeviceType.强归属),
    Android_Scales("Android_Scales", "安卓收银秤", "Android_Scales", 1, ZuulDeviceType.强归属),
    MH_WEB_Scales("MH_WEB_Scales", "商户WEB终端", "MH_WEB_Scales", 7, ZuulDeviceType.强归属),
    BT_Crane_Scales("BT_Crane_Scales", "蓝牙吊秤", "BT_Crane_Scales", 2, ZuulDeviceType.归档在案),
    PC_Scales("PC_Scales", "PC收银秤", "PC_Scales", 4, ZuulDeviceType.强归属),
    BT_Scales("BT_Scales", "蓝牙收银秤", "BT_Scales", 5, ZuulDeviceType.强归属),
    VPS_PC_Scales("VPS_PC_Scales", "三方PC收银秤", "VPS_PC_Scales", 3, ZuulDeviceType.强归属),
    Car_Horizontal_Scales("Car_Horizontal_Scales", "汽车衡", "Car_Horizontal_Scales", 6, ZuulDeviceType.归档在案),
    Car_Horizontal_Scales_Display("CHD_Scales", "汽车衡(显示屏版本)", "CHD_Scales", 10, ZuulDeviceType.归档在案),
    Factory_Tool("Factory_Tool", "工厂测试工具", "Factory_Tool", 8, ZuulDeviceType.授权),
    BT_Print_Scales("BT_Print_Scales", "蓝牙打印秤", "BT_Print_Scales", 9, ZuulDeviceType.归档在案),
    JHSDK("JHSDK", "JHSDK对接", "JHSDK", 10, ZuulDeviceType.强归属),


    Other_Device("Other_Device", "其余设备", "Other_Device", 100, ZuulDeviceType.弱归属),
    ZXD_Display("ZXD_Display", "显示屏设备", "ZXD_Display", 101, ZuulDeviceType.弱归属),;

    private final String type;

    private final String description;

    private final String sign;

    private final Integer itype;// 0~65535

    private final ZuulDeviceType zuulDeviceType;

    DeviceType(String type, String description, String sign, Integer itype, ZuulDeviceType zuulDeviceType) {
        this.type = type;
        this.description = description;
        this.sign = sign;
        this.itype = itype;
        this.zuulDeviceType = zuulDeviceType;
    }

    public String getType() {
        return type;
    }

    public String getDescription() {
        return description;
    }

    public String getSign() {
        return sign;
    }

    public Integer getItype() {
        return itype;
    }

    public ZuulDeviceType getZuulDeviceType() {
        return zuulDeviceType;
    }

    /**
     * @description: 获取设备类型
     **/
    public static DeviceType deviceType(Integer itype) {
        if (Objects.isNull(itype)) return DeviceType.Simple_Scales;
        for (DeviceType deviceType : DeviceType.values()) {
            if (deviceType.getItype().equals(itype)) {
                return deviceType;
            }
        }
        return null;
    }

    /**
     * @description: 获取设备类型
     **/
    public static DeviceType deviceType(String type) {
        if (StringUtils.isBlank(type)) return DeviceType.Simple_Scales;
        for (DeviceType deviceType : DeviceType.values()) {
            if (deviceType.getType().equals(type) || deviceType.getSign().equals(type)) {
                return deviceType;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "DeviceType{" +
                "type='" + type + '\'' +
                ", description='" + description + '\'' +
                ", sign='" + sign + '\'' +
                ", itype=" + itype +
                '}';
    }
}
