package com.jhscale.common.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: Enable
 * @projectName common
 * @description: TODO
 * @date 2020-11-187:36
 */
public enum Enable {

    UNABLE(0), ENABLE(1), SAFEGUARD(2), DISABLE(3);

    private Integer val;

    Enable(Integer val) {
        this.val = val;
    }

    public Integer getVal() {
        return val;
    }

    /**
     * @description: 启用状态
     **/
    public static Enable enable(String enable) {
        if (StringUtils.isBlank(enable)) return Enable.UNABLE;
        for (Enable e : Enable.values()) {
            if (enable.equals(e.val.toString())) return e;
        }
        return Enable.UNABLE;
    }

    /**
     * @description: 启用状态
     **/
    public static Enable enable(Integer enable) {
        if (Objects.isNull(enable)) return Enable.UNABLE;
        for (Enable e : Enable.values()) {
            if (enable.equals(e.val)) return e;
        }
        return Enable.UNABLE;
    }


    @Override
    public String toString() {
        return String.valueOf(this.val);
    }
}
