package com.jhscale.common.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title: ErrorCode
 * @description: TODO
 * @date 2024/8/19 18:05
 */
public enum ErrorCode {

    铅封异常("01FF", "铅封异常"),
    铅封复位("01FE", "铅封复位"),
    应用升级("01FD", "应用升级"),
    打印机1固件升级("01FC", "打印机1固件升级"),
    打印机2固件升级("01FB", "打印机2固件升级"),
    秤台固件升级("01FA", "秤台固件升级"),
    云未知支付("195", "CP_UN_KNOW_Pay"),
    吉卡云会员未知支付("65546", "JKY_UN_KNOW_Pay"),
    卡付未知支付("65537", "Card_UN_KNOW_Pay"),
    其他未知支付("65538", "Other_UN_KNOW_Pay"),
    ;

    public final String errCode;

    private final String errMsg;

    ErrorCode(String errCode, String errMsg) {
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public static ErrorCode errorCode(String errCode) {
        if (StringUtils.isNotBlank(errCode)) {
            for (ErrorCode value : ErrorCode.values()) {
                if (errCode.equalsIgnoreCase(value.getErrCode())) return value;
            }
        }
        return null;
    }

    public String getErrCode() {
        return errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }
}
