package com.jhscale.common.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: OrderBizType
 * @projectName ysscale-base
 * @description: TODO
 * @date 2021/4/2517:22
 */
public enum PayBizType {

    主扫("SCAN", "商户主扫"),
    被扫("SWEPT", "商户被扫"),
    全部("ALL", "主扫被扫兼容"),
    终端("TERM", "终端完成");

    private String type;

    private String description;

    PayBizType(String type, String description) {
        this.type = type;
        this.description = description;
    }

    public String getType() {
        return type;
    }

    public String getDescription() {
        return description;
    }

    public static PayBizType bizType(String type) {
        if (StringUtils.isNotBlank(type)) {
            for (PayBizType bizType : PayBizType.values()) {
                if (bizType.getType().equals(type)) return bizType;
            }
        }
        return null;
    }
}
