package com.jhscale.common.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: PayType
 * @projectName common
 * @description: 支付方式
 * @date 2022/10/1012:43
 */
public enum PayType {

    PAY_FAIL(0, "00", "支付失败"),
    ALI_PAY(1, "01", "支付宝支付"),
    WECHAT_PAY(2, "02", "微信支付"),
    UNION_PAY(3, "03", "云闪付"),
    Special_PAY3(4, "04", "特殊支付3"),
    Special_PAY4(5, "05", "特殊支付4"),
    Special_PAY5(6, "06", "特殊支付5"),
    Special_PAY6(7, "07", "特殊支付6"),
    UNKNOWN_PAY(8, "08", "未知支付");

    // 支付渠道
    private int type;

    private String strType;

    // 描述
    private String description;

    PayType(int type, String strType, String description) {
        this.type = type;
        this.strType = strType;
        this.description = description;
    }

    public Integer getType() {
        return type;
    }

    public String getStrType() {
        return strType;
    }

    public String getDescription() {
        return description;
    }

    public static PayType type(Integer type) {
        if (Objects.nonNull(type)) {
            for (PayType payType : PayType.values()) {
                if (payType.getType().equals(type)) return payType;
            }
        }
        return PayType.UNKNOWN_PAY;
    }

    public static PayType type(String strType) {
        if (StringUtils.isNotBlank(strType)) {
            for (PayType payType : PayType.values()) {
                if (payType.getStrType().equals(strType) || payType.getType().toString().equals(strType))
                    return payType;
            }
        }
        return PayType.UNKNOWN_PAY;
    }


}
