package com.jhscale.common.em;

import com.jhscale.common.model.simple.PaySimple;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author 王列
 * @Package com.ysscale.common.enm
 * @Description: ysscale 订单支付类型(支付渠道)
 * @date 2018/4/14 17:47
 */
public enum PayWay {

    Aggregate_PAY(0, "00", false, "聚合支付"),
    ALI_PAY(1, "01", true, "支付宝支付"),
    WECHAT_PAY(2, "02", true, "微信支付"),
    CASH_PAY(3, "03", false, "现金支付"),
    JK_PAY(4, "04", false, "吉卡云支付"),
    OTHER_PAY(5, "05", false, "其他聚合支付"),
    WECHAT_OA_PAY(6, "06", false, "微信收付通支付"),
    UNION_T_PAY(7, "07", false, "银联支付"),
    UNION_PAY(70, "70", true, "云闪付"), // 云闪付
    JH_PAY(71, "71", true, "龙支付"),// 建行支付
    YZ_PAY(72, "72", true, "邮政支付"),// 邮政支付
    // NH_PAY(73, "73", true,"农行支付"),// 农行支付
    ICBC_PAY(74, "74", true, "工行支付"),// 工行支付
    UNION_PAY2(75, "75", true, "云闪付天满"),// 云闪付天满
    FUBEI_PAY(76, "76", true, "付呗支付"),// 付呗支付
    SQB_PAY(77, "77", true, "收钱吧支付"),// 收钱吧支付
    SB_PAY(78, "78", true, "扫呗支付"),// 扫呗支付
    O_UNION_PAY(700, "700", false, "其他银联支付"),// 其他银联支付
    QQ_PAY(8, "08", true, "QQ支付"), // QQ
    /**
     * @description: 只用来统计
     **/
    TOTAL_PAY(10, "10", false, "汇总");

    // 支付渠道
    private final int type;

    private final String strType;

    private final boolean cloudChannel;

    // 描述
    private final String description;

    PayWay(int type, String strType, boolean cloudChannel, String description) {
        this.type = type;
        this.strType = strType;
        this.cloudChannel = cloudChannel;
        this.description = description;
    }

    public Integer getType() {
        return type;
    }

    public String getStrType() {
        return strType;
    }

    public boolean isCloudChannel() {
        return cloudChannel;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public String toString() {
        return String.valueOf(this.type);
    }

    public static PayWay orderPay(Integer type) {
        if (Objects.nonNull(type)) {
            for (PayWay payWay : PayWay.values()) {
                if (payWay.getType().equals(type)) return payWay;
            }
        }
        return null;
    }

    public static PayWay orderPay(String type) {
        if (StringUtils.isNotBlank(type)) {
            for (PayWay payWay : PayWay.values()) {
                if (payWay.getType().toString().equals(type)) return payWay;
            }
        }
        return null;
    }

    public static PayWay strType(String type) {
        if (StringUtils.isNotBlank(type)) {
            for (PayWay payWay : PayWay.values()) {
                if (payWay.getStrType().equals(type)) return payWay;
            }
        }
        return null;
    }

    public static List<PaySimple> cloudPayChannel() {
        List<PaySimple> channels = new ArrayList<>();
        for (PayWay value : PayWay.values()) {
            if (value.cloudChannel) channels.add(new PaySimple(value.type, value.strType, value.description));
        }
        return channels;
    }
}
