package com.jhscale.common.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: Platform
 * @projectName common
 * @description: TODO
 * @date 2023/3/1017:22
 */
public enum Platform {

    C("C", "TMS软件"),
    V("V", "第三方"),
    W("W", "Web终端"),
    WA("A", "WEB_APP"),
    WP("P", "WEB_HTML"),
    S("S", "内部服务器"),
    PS("B", "POS终端"),;

    private String sign;

    private String description;

    Platform(String sign, String description) {
        this.sign = sign;
        this.description = description;
    }

    /**
     * @description: 标识查找
     **/
    public static Platform sign(String sign) {
        if (StringUtils.isNotBlank(sign)) {
            for (Platform platform : Platform.values()) {
                if (sign.equalsIgnoreCase(platform.sign)) return platform;
            }
        }
        return null;
    }

    public String getSign() {
        return sign;
    }

    public String getDescription() {
        return description;
    }
}
