package com.jhscale.common.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: Project
 * @projectName common
 * @description: 项目
 * @date 2023/2/1313:51
 */
public enum Project {

    PLATFORM(0, "platform", "platform", "平台项目统称"),
    API(1, "api", "api", "API核心项目"),
    REPORT(2, "report", "report", "报表项目"),
    SQUARE(3, "square", "report/square", "报表汇总项目"),
    MO_SQUARE(4, "mo_square", "report/mo_square", "报表业务项目"),
    RE_SQUARE(5, "mo_square", "report/re_square", "报表对账项目"),
    MIGRATION(6, "migration", "report/migration", "报表迁移项目"),
    ZXD_MARKET(7, "zxd_market", "zxd/market", "知鲜到_市场_智慧农贸"),
    ZXD_MALL(8, "zxd_mall", "zxd/mall", "知鲜到商城"),
    ERP(9, "erp", "erp", "进销存"),
    BASIC(10, "basic", "basic", "品项"),
    BASIC_Data(11, "basic", "basic/data", "品项数据同步"),
    BASIC_PLU(12, "basic_plu", "basic/plu", "品项商品图片"),
    BASIC_AI(13, "basic_ai", "basic/ai", "品项AI采集"),
    BASIC_Material(14, "basic_material", "basic/material", "素材物料"),
    BASIC_AI_MODEL(15, "basic_ai_model", "basic/ai_model", "品项AI模型文件"),
    BASIC_AI_OTHER(16, "basic_ai_other", "basic/ai_other", "品项AI其他文件"),
    PLATFORM_AI(17, "platform_ai", "platform/ai", "平台AI采集"),
    PLATFORM_AI_MODEL(18, "platform_ai_model", "platform/ai_model", "平台AI模型文件"),
    PLATFORM_AI_OTHER(19, "platform_ai_other", "platform/ai_other", "平台AI其他文件"),
    PLATFORM_AI_Result(20, "platform_ai_result", "platform/ai_result", "平台AI结果文件"),
    LOG_PICTURE(21, "report", "log_picture", "日志图片"),
    ;

    // 序号
    private final Integer serial;

    // 项目名称
    private String project;

    // oss路径
    private String ossPath;

    // 描述
    private String description;

    Project(Integer serial, String project, String ossPath, String description) {
        this.serial = serial;
        this.project = project;
        this.ossPath = ossPath;
        this.description = description;
    }

    public static Project serial(Integer serial) {
        if (Objects.nonNull(serial)) {
            for (Project project : Project.values()) {
                if (serial.equals(project.serial)) return project;
            }
        }
        return null;
    }

    public static Project project(String project) {
        if (StringUtils.isNotBlank(project)) {
            for (Project project1 : Project.values()) {
                if (project.equals(project1.project)) return project1;
            }
        }
        return null;
    }

    public String getProject() {
        return project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getOssPath() {
        return ossPath;
    }

    public void setOssPath(String ossPath) {
        this.ossPath = ossPath;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
