package com.jhscale.common.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: SequenceRule
 * @projectName common
 * @description: 业务编号规则
 * @date 2020-11-2416:15
 */
public enum SequenceRule {

    /**
     * @description: 平台编号
     **/
    管理员编号("管理员编号", "GM", "1000", 0, 1, 12, "0"),

    /**
     * @description: 商户编号
     **/
    商户编号("商户编号", "MH", "2000", 0, 1, 12, "0"),
    店铺编号("店铺编号", "SL", "2001", 0, 1, 12, "0"),
    设备编号("设备编号", "DT", "2011", 0, 1, 12, "0"),
    显示器编号("显示器编号", "LCD", "2002", 0, 1, 12, "0"),
    会员积分套餐编号("会员积分套餐编号", "IM", "2003", 0, 1, 12, "0"),
    会员储值套餐编号("会员储值套餐编号", "M", "2004", 0, 1, 12, "0"),
    农贸市场编号("农贸市场编号", "MK", "2005", 0, 1, 12, "0"),
    农贸市场店铺编号("农贸市场商户编号", "MKH", "2006", 0, 1, 12, "0"),
    电子商城商户("电子商城商户", "MMM", "2007", 0, 1, 12, "0"),
    电子商城服务商("电子商城服务商", "MMS", "2008", 0, 1, 12, "0"),
    电子商城配送员("电子商城配送员", "MMD", "2009", 0, 1, 12, "0"),
    VPS_设备编号("VPS_设备编号", "VPSE", "2010", 0, 1, 12, "0"),
    ANDROID_设备编号("ANDROID_设备编号", "ANDROIDE", "2011", 0, 1, 12, "0"),
    汽车衡设备编号("汽车衡设备编号", "TS", "2015", 0, 1, 12, "0"),
    农贸市场摊位编号("农贸市场摊位编号", "MKS", "2016", 0, 1, 6, "0"),
    @Deprecated
    子账号编号("子账号编号", "SA", "2012", 0, 1, 12, "0"),
    商户子账号编号("商户子账号编号", "SAMH", "2013", 0, 1, 12, "0"),

    /**
     * @description: 经销商编号
     **/
    经销商编号("经销商编号", "AG", "3000", 0, 1, 12, "0"),
    经销商子账号编号("经销商子账号编号", "SAAG", "3001", 0, 1, 12, "0"),


    /**
     * @description: 服务商编号
     **/
    服务商编号("服务商编号", "ISP", "4000", 0, 1, 12, "0"),
    服务商子账号编号("服务商子账号编号", "SAISP", "4001", 0, 1, 12, "0"),


    /**
     * @description: 客户编号
     **/
    客户编号("客户编号", "CSR", "5000", 0, 1, 12, "0"),
    小程序商户客户编号("小程序商户客户编号", "MINIMHCSR", "5001", 0, 1, 8, "0"),
    客户套餐编号("客户套餐编号", "CSRM", "5002", 0, 1, 12, "0"),
    家庭组编号("家庭组编号", "FM", "5003", 0, 1, 12, "0"),
    实体卡编号("实体卡编号", "ECD", "5004", 0, 1, 12, "0"),
    商城客户编号("商城客户编号", "MCSR", "5005", 0, 1, 12, "0"),

    /**
     * 签约编号
     */
    支付宝签约编号("支付宝签约", "AL-AP", "ALIAP", 0, 1, 17, "0"),
    微信签约编号("微信签约", "WX-AP", "WXAP", 0, 1, 17, "0"),
    微信收付通签约编号("微信收付通签约", "WX-AO-AP", "WXAOAP", 0, 1, 17, "0"),

    /**
     * 模板编号
     */
    平台模板编号("平台模板编号", "JH-TEMP", "6000", 0, 1, 12, "0"),
    市场模板编号("市场模板编号", "TEMP", "6001", 0, 1, 12, "0"),

    /**
     * 知鲜到费用管理
     */
    市场统一费用标识("市场统一费用标识", "MAR_COST", "6003", 0, 1, 12, "0"),
    指定摊位费用标识("指定摊位费用标识", "STALL_COST", "6004", 0, 1, 12, "0"),
    农贸市场方marketId("农贸市场方marketId", "MAID", "6005", 0, 1, 4, "0"),


    /**
     * ERP
     */
    单据编号("单据编号", "ERP-BILL", "7000", 0, 1, 12, "0"),
    票据分类编号("票据分类编号", "ERP-CLA", "7001", 0, 1, 12, "0"),
    单据详情编号("单据详情编号", "ERP-DET", "7002", 0, 1, 12, "0"),
    票据系统参数编号("票据系统参数编号", "BILL-PAR", "7003", 0, 1, 12, "0"),
    票据种类编号("票据种类编号", "ERP-TYPE", "7004", 0, 1, 12, "0"),
    分类档案编号("分类档案编号", "ERP-CATE", "7005", 0, 1, 12, "0"),
    仓库编号("仓库编号", "ERP-DEP", "7006", 0, 1, 12, "0"),
    ERP商品编号("ERP商品编号", "ERP-PLU", "7007", 0, 1, 12, "0"),
    ERP商品条码编号("ERP商品条码编号", "ERP-BAR", "7008", 0, 1, 12, "0"),
    ERP商品配置参数编号("ERP商品配置参数编号", "PLU-PAR", "7009", 0, 1, 12, "0"),
    赠退原因编号("赠退原因编号", "ERP-PRR", "7010", 0, 1, 12, "0"),
    商品规格编号("商品规格编号", "ERP-SPECS", "7011", 0, 1, 12, "0"),
    商品同步编号("商品同步编号", "ERP-PDS", "7012", 0, 1, 12, "0"),
    结算单编号("结算单编号", "ERP-SET", "7013", 0, 1, 12, "0"),
    结算单据编号("结算单据编号", "SET-BiLL", "7014", 0, 1, 12, "0"),
    ERP商品库存编号("ERP商品库存编号", "ERP-STOCK", "7015", 0, 1, 12, "0"),
    单品进销存编号("单品进销存编号", "STOCK-INFO", "7016", 0, 1, 12, "0"),
    供应商编号("供应商编号", "ERP-SUP", "7017", 0, 1, 12, "0"),
    商户系统参数编号("商户系统参数编号", "ERP-SYS", "7018", 0, 1, 12, "0"),
    单位档案编号("单位档案编号", "ERP-UNIT", "7019", 0, 1, 12, "0"),
    单据编号MG("单据编号MG", "BILL-FLOW", "7020", 0, 1, 12, "0"),
    单据信息编号("单据信息编号", "BILL-INFO", "7021", 0, 1, 12, "0"),
    库存流水编号("库存流水编号", "STOCK-FLOW", "7022", 0, 1, 12, "0"),
    商品信息的结算汇总("商品信息的结算汇总", "MER-SUM", "7023", 0, 1, 12, "0"),
    单据配置编号("单据配置编号", "BILL_CONF", "7024", 0, 1, 12, "0"),
    设备仓库编号("设备仓库编号", "DEPOT_BA", "7025", 0, 1, 12, "0"),
    拆组方案编号("拆组方案编号", "DIS_PLAN", "7026", 0, 1, 12, "0"),
    拆组内容编号("拆组内容编号", "DIS_CONT", "7027", 0, 1, 12, "0"),

    单据业务编号("单据业务编号", "BUS-BILL", "7800", 0, 1, 12, "0"),
    票据分类业务编号("票据分类业务编号", "BUS-CLA", "7801", 0, 1, 12, "0"),
    单据详情业务编号("单据详情业务编号", "BUS-DET", "7802", 0, 1, 12, "0"),
    票据系统参数业务编号("票据系统参数业务编号", "BUS-PAR", "7803", 0, 1, 12, "0"),
    票据种类业务编号("票据种类业务编号", "BUS-TYPE", "7804", 0, 1, 12, "0"),
    分类档案业务编号("分类档案业务编号", "BUS-CATE", "7805", 0, 1, 12, "0"),
    仓库业务编号("仓库业务编号", "BUS-DEP", "7806", 0, 1, 12, "0"),
    ERP商品业务编号("ERP商品业务编号", "BUS-PLU", "7807", 0, 1, 12, "0"),
    ERP条码业务编号("ERP条码业务编号", "BUS-BAR", "7808", 0, 1, 12, "0"),
    ERP配置业务编号("ERP配置业务编号", "BUS-PAR", "7809", 0, 1, 12, "0"),
    赠退原因业务编号("赠退原因业务编号", "BUS-PRR", "7810", 0, 1, 12, "0"),
    商品规格业务编号("商品规格业务编号", "BUS-SPECS", "7811", 0, 1, 12, "0"),
    商品同步业务编号("商品同步业务编号", "BUS-PDS", "7812", 0, 1, 12, "0"),
    结算单业务编号("结算单业务编号", "BUS-SET", "7813", 0, 1, 12, "0"),
    结算单据业务编号("结算单据业务编号", "BUS-BiLL", "7814", 0, 1, 12, "0"),
    ERP库存业务编号("ERP库存业务编号", "BUS-STOCK", "7815", 0, 1, 12, "0"),
    单品进销存业务编号("单品进销存业务编号", "BUS-INFO", "7816", 0, 1, 12, "0"),
    供应商业务编号("供应商业务编号", "BUS-SUP", "7817", 0, 1, 12, "0"),
    系统参数业务编号("系统参数业务编号", "BUS-SYS", "7818", 0, 1, 12, "0"),
    单位业务编号("单位业务编号", "BUS-UNIT", "7819", 0, 1, 12, "0"),
    单据业务编号MG("单据业务编号MG", "BUS-FLOW", "7820", 0, 1, 12, "0"),
    单据信息业务编号("单据信息业务编号", "BUS-INFO", "7821", 0, 1, 12, "0"),
    拆组方案业务编号("拆组方案业务编号", "PLAN_NO", "7822", 0, 1, 12, "0"),

    /**
     * 迁移导出批次号
     */
    迁移导出批次号("迁移导出批次号", "MI-EX", "8001", 0, 1, 12, "0"),

    /**
     * 问题标识
     */
    问题标识("问题标识", "FAQ", "8002", 0, 1, 12, "0"),
    归档问题标识("归档问题标识", "FQA", "8003", 0, 1, 12, "0"),

    /**
     * 德邦设备生成批次号
     */
    德邦设备生成批次号("德邦设备生成批次号", "DBMAC", "8004", 0, 1, 12, "0"),

    /**
     * @Description: erp人员, 区域
     */
    区域标识("区域标识", "REGION", "8005", 0, 1, 12, "0"),
    职称系统业务编号("职称系统业务编号", "JOB-TITLE", "8006", 0, 1, 12, "0"),
    人员系统业务编号("人员系统业务编号", "PERSONNEL", "8007", 0, 1, 12, "0"),
    ERP店铺等级业务编号("ERP店铺等级业务编号", "LEVEL", "8008", 0, 1, 12, "0"),

    ;
    /**
     * @description: 名称
     **/
    private String name;

    /**
     * @description: 简写
     **/
    private String abbr;

    /**
     * @description: 前缀
     **/
    private String prefix;

    /**
     * @description: 编号
     **/
    private int no;

    /**
     * @description: 步长
     **/
    private int step;

    /**
     * @description: 长度
     **/
    private int length;

    /**
     * @description: 重置 0-否 1-是
     **/
    private String reset;

    SequenceRule(String name, String abbr, String prefix, int no, int step, int length, String reset) {
        this.name = name;
        this.abbr = abbr;
        this.prefix = prefix;
        this.no = no;
        this.step = step;
        this.length = length;
        this.reset = reset;
    }

    /**
     * @description: 前缀找Sequence
     **/
    public static SequenceRule prefix(String prefix) {
        if (StringUtils.isNotBlank(prefix)) {
            for (SequenceRule sequenceRule : SequenceRule.values()) {
                if (prefix.equals(sequenceRule.getPrefix())) return sequenceRule;
            }
        }
        return null;
    }

    /**
     * @description: 简写找Sequence
     **/
    public static SequenceRule abbr(String abbr) {
        if (StringUtils.isNotBlank(abbr)) {
            for (SequenceRule sequenceRule : SequenceRule.values()) {
                if (abbr.equals(sequenceRule.getAbbr())) return sequenceRule;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAbbr() {
        return abbr;
    }

    public void setAbbr(String abbr) {
        this.abbr = abbr;
    }

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public int getNo() {
        return no;
    }

    public void setNo(int no) {
        this.no = no;
    }

    public int getStep() {
        return step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public int getLength() {
        return length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getReset() {
        return reset;
    }

    public void setReset(String reset) {
        this.reset = reset;
    }

    @Override
    public String toString() {
        return "SequenceType{" +
                "name='" + name + '\'' +
                ", abbr='" + abbr + '\'' +
                ", prefix='" + prefix + '\'' +
                ", no=" + no +
                ", step=" + step +
                ", length=" + length +
                ", reset='" + reset + '\'' +
                '}';
    }
}
