package com.jhscale.common.em;

/**
 * @author lie_w
 * @title: DeviceConfi
 * @projectName common
 * @description: TODO
 * @date 2023/3/240:21
 */
public enum ServerDeviceConfig {

    日志("0", "日志", ServerParamType.使用参数, SwitchState.启用.getEnable(), SwitchState.不启用),
    云支付("1", "云支付", ServerParamType.使用参数, SwitchState.不启用.getEnable(), SwitchState.不启用),
    吉卡云("2", "吉卡云", ServerParamType.使用参数, SwitchState.不启用.getEnable(), SwitchState.不启用),
    厂部发卡("3", "厂部发卡", ServerParamType.使用参数, SwitchState.不启用.getEnable(), SwitchState.不启用),
    吉卡云充值("4", "吉卡云充值", ServerParamType.使用参数, SwitchState.不启用.getEnable(), SwitchState.启用),
    第三方配置("5", "第三方配置", ServerParamType.使用参数, SwitchState.不启用.getEnable(), SwitchState.启用),
    知鲜到商城("6", "知鲜到商城", ServerParamType.使用参数, SwitchState.不启用.getEnable(), SwitchState.不启用),
    商城订单服务器通知("7", "商城订单服务器通知", ServerParamType.使用参数, SwitchState.不启用.getEnable(), SwitchState.启用),
    设备锁定("8", "设备锁定", ServerParamType.使用参数, SwitchState.不启用.getEnable(), SwitchState.不启用),
    传感器("9", "传感器", ServerParamType.使用参数, "", SwitchState.不启用),
    AI功能("10", "AI功能", ServerParamType.出厂参数, SwitchState.不启用.getEnable(), SwitchState.不启用),
    AI采集("11", "AI采集", ServerParamType.使用参数, SwitchState.不启用.getEnable(), SwitchState.不启用),


    设备使用超时时间("201", "设备使用超时时间", ServerParamType.使用参数, "", SwitchState.启用),
    设备使用范围("202", "设备使用范围（公里）", ServerParamType.使用参数, "", SwitchState.启用),

    交易结算("401", "交易结算", ServerParamType.使用参数, SwitchState.不启用.getEnable(), SwitchState.启用),
    库存结算("402", "库存结算", ServerParamType.使用参数, SwitchState.不启用.getEnable(), SwitchState.启用),;

    // 参数编号
    private String type;

    // 类型名称
    private String name;

    // 0-常规使用参数 1-出厂参数
    private ServerParamType init_type;

    // 是否启用 0-禁用 1-启用 其他参数
    private String defVal;

    // 是否可编辑 0-不可编辑 1-可编辑
    private SwitchState edit;

    ServerDeviceConfig(String type, String name, ServerParamType init_type, String defVal, SwitchState edit) {
        this.type = type;
        this.name = name;
        this.init_type = init_type;
        this.defVal = defVal;
        this.edit = edit;
    }

    public String getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public ServerParamType getInit_type() {
        return init_type;
    }

    public String getDefVal() {
        return defVal;
    }

    public SwitchState getEdit() {
        return edit;
    }
}
