package com.jhscale.common.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author Loveven
 * @title: SwitchTypeEnum
 * @projectName ysscale-base
 * @description: TODO
 * @date 2019/10/323:48
 */
public enum SwitchState {

    不启用("0", false), 启用("1", true), 禁用("2", false);

    private String enable;

    private boolean open;

    SwitchState(String enable, boolean open) {
        this.enable = enable;
        this.open = open;
    }

    public String getEnable() {
        return enable;
    }

    public Integer enable(){return Integer.parseInt(this.enable);}

    public boolean isOpen() {
        return open;
    }

    /**
     * @description: 开关状态
     **/
    public static SwitchState switchState(String enable) {
        if (StringUtils.isBlank(enable)) return SwitchState.不启用;
        for (SwitchState switchState : SwitchState.values()) {
            if (enable.equals(switchState.getEnable())) return switchState;
        }
        return SwitchState.不启用;
    }

    /**
     * @description: 开关状态
     **/
    public static SwitchState switchState(Integer enable) {
        if (Objects.isNull(enable)) return SwitchState.不启用;
        for (SwitchState switchState : SwitchState.values()) {
            if (enable.toString().equals(switchState.getEnable())) return switchState;
        }
        return SwitchState.不启用;
    }

    /**
     * @description: 开关状态
     **/
    public static SwitchState switchState(char c) {
        for (SwitchState value : SwitchState.values()) {
            if (value.getEnable().equals(String.valueOf(c))) return value;
        }
        return SwitchState.不启用;
    }

    @Override
    public String toString() {
        return this.enable;
    }
}
