package com.jhscale.common.em;

import com.jhscale.common.model.device.DConstant;

/**
 * @author lie_w
 * @title: SyncDataType
 * @projectName common
 * @description: TODO
 * @date 2023/3/88:52
 */
public enum SyncDataType {

    ALL(DConstant.ALL, 0, "所有数据备份信息", "com.jhscale.meter.wifi.entity.Backup"),

    //服务器业务相关同步数据类型
    PLU(DConstant.PLU, 1, "商品信息", "com.jhscale.meter.wifi.entity.PLU"),
    CLS(DConstant.CLS, 2, "分组", "com.jhscale.meter.wifi.entity.Group"),
    SAL(DConstant.SAL, 3, "营业员", "com.jhscale.meter.wifi.entity.Assistant"),
    SCP(DConstant.SCP, 4, "快捷键", "com.jhscale.meter.wifi.entity.Keyboard"),
    SCG(DConstant.SCG, 5, "POS快捷页", ""),
    SGF(DConstant.SGF, 6, "POS快捷页模板", ""),

    //其他同步数据类型
    TMS(DConstant.TMS, 7, "数据参数", "com.jhscale.meter.wifi.entity.Data"),
    TMT(DConstant.TMT, 8, "文本参数", "com.jhscale.meter.wifi.entity.Text"),
    BAR(DConstant.BAR, 9, "条码参数", ""/*"com.jhscale.meter.wifi.entity.BarCode"*/),
    LTB(DConstant.LTB, 10, "小秤标签格式1", ""),
    LTS(DConstant.LTS, 11, "小秤标签格式2", ""),
    LTE(DConstant.LTE, 12, "小秤标签格式3", ""),
    LAT(DConstant.LAT, 13, "POS标签格式", ""),
    BMP(DConstant.BMP, 14, "位图", ""),
    SAJ(DConstant.SAJ, 15, "营业员职称", ""),

    // INF(DConstant.INF, 15, "信息获取", ""),
    // INF_INA(DConstant.INF_INA,16 , "信息获取 INA", ""),
    // INF_INM(DConstant.INF_INM, 17, "信息获取 INM", ""),
    // INF_INF(DConstant.INF_INF,18 , "信息获取 INF", ""),
    // MAC(DConstant.MAC, 19, "MAC≈INF", ""),
    // TIM(DConstant.TIM,20 , "TIM", "")
    ;

    //同步数据类型
    private final String type;
    //类型序号
    private Integer no;
    //类型描述
    private String note;
    //类型对应的指令对象
    private String cmdClazz;

    SyncDataType(String type, Integer no, String note, String cmdClazz) {
        this.type = type;
        this.no = no;
        this.note = note;
        this.cmdClazz = cmdClazz;
    }

    public String getType() {
        return type;
    }

    public Integer getNo() {
        return no;
    }

    public String getNote() {
        return note;
    }

    public String getCmdClazz() {
        return cmdClazz;
    }

    /**
     * @description: 类型匹配
     **/
    public static SyncDataType type(String type) {
        for (SyncDataType value : SyncDataType.values()) {
            if (value.type.equalsIgnoreCase(type)) return value;
        }
        return null;
    }

    /**
     * @description: 序号匹配
     **/
    public static SyncDataType no(Integer no) {
        for (SyncDataType value : SyncDataType.values()) {
            if (value.no.equals(no)) return value;
        }
        return null;
    }
}
