package com.jhscale.common.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: TradeType
 * @projectName common
 * @description: TODO
 * @date 2022/9/2118:19
 */
public enum TradeType {
    // 没有实际数据意义
    汇总(-1, "-01", "汇总"),

    销售(0, "00", "销售"),
    退货(1, "01", "退货"),
    未确认(2, "02", "未确认"),
    清除(3, "03", "清除"),
    挂单(4, "04", "挂单"),
    自动模式(5, "05", "自动模式"),
    入库(10, "0A", "入库"),
    出库(11, "0B", "出库"),
    盘库(12, "0C", "盘库"),
    订货(13, "0D", "订货"),
    损耗(14, "0E", "损耗"),
    错误日志(255, "FF", "错误日志"),

    /************** ERP票据单 *****************/

    采购进货(1000, "03E8", "采购进货"),
    采购退货(1001, "03E9", "采购退货"),
    领用入库(1002, "03EA", "领用入库"),
    领用出库(1003, "03EB", "领用出库"),
    调拨入库(1004, "03EC", "调拨入库"),
    调拨出库(1005, "03ED", "调拨出库"),
    录入入库(1006, "03EE", "录入入库"),
    销售出库(1007, "03EF", "销售出库"),
    退货入库(1008, "03F0", "退货入库"),
    损溢单(1009, "03F1", "损溢单"),
    盘点单(1010, "03F2", "盘点单(根据历史记录盘点)"),
    盘点单1(1011, "03F3", "盘点单1(根据现场状况盘点)"),;

    private Integer type;

    private String hex;

    private String name;

    TradeType(Integer type, String hex, String name) {
        this.type = type;
        this.hex = hex;
        this.name = name;
    }

    /**
     * @description: Type 查询 交易类型
     **/
    public static TradeType type(Integer type) {
        if (Objects.nonNull(type)) {
            for (TradeType tradeType : TradeType.values()) {
                if (type.equals(tradeType.getType())) return tradeType;
            }
        }
        return null;
    }

    /**
     * @description: Int String Type 查询 交易类型
     **/
    public static TradeType typeIntStr(String type) {
        if (StringUtils.isNotBlank(type)) {
            return type(Integer.parseInt(type));
        }
        return null;
    }

    /**
     * @description: HEX 查询交易类型
     **/
    public static TradeType hex(String hex) {
        if (StringUtils.isNotBlank(hex)) {
            for (TradeType tradeType : TradeType.values()) {
                if (hex.equalsIgnoreCase(tradeType.getHex())) return tradeType;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getHex() {
        return hex;
    }

    public void setHex(String hex) {
        this.hex = hex;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
