package com.jhscale.common.em;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: ZuulDeviceType
 * @projectName common
 * @description: TODO
 * @date 2021/5/3018:10
 */
public enum ZuulDeviceType {

    强归属(0, "强归属", "Attribution"),
    弱归属(1, "弱归属", "Weak-Attribution"),
    授权(2, "授权", "Auth"),
    归档在案(3, "归档在案", "Document");

    private Integer zuulType;

    private String name;

    private String simple;


    ZuulDeviceType(Integer zuulType, String name, String simple) {
        this.zuulType = zuulType;
        this.name = name;
        this.simple = simple;
    }

    public static ZuulDeviceType zuulDeviceType(Integer zuulType) {
        if (Objects.isNull(zuulType)) return null;
        for (ZuulDeviceType zuulDeviceType : ZuulDeviceType.values()) {
            if (zuulDeviceType.getZuulType().equals(zuulType)) return zuulDeviceType;
        }
        return null;
    }

    public static ZuulDeviceType zuulDeviceType(String simple) {
        if (StringUtils.isBlank(simple)) return null;
        for (ZuulDeviceType zuulDeviceType : ZuulDeviceType.values()) {
            if (zuulDeviceType.getSimple().equals(simple)) return zuulDeviceType;
        }
        return null;
    }

    public Integer getZuulType() {
        return zuulType;
    }

    public String getName() {
        return name;
    }

    public String getSimple() {
        return simple;
    }
}
