package com.jhscale.common.exception;

import com.jhscale.common.content.JHContents;

/**
 * @author lie_w
 * @title: GeneralInternation
 * @projectName common
 * @description: 通用国际化
 * @date 2020-12-0315:39
 */
public enum GeneralInternational {

    接口版本无效(JHContents.SIGN_INTERNATIONAL_PREFIX + "version_invalid", "接口版本无效"),
    随机数无效(JHContents.SIGN_INTERNATIONAL_PREFIX + "nonce_str_invalid", "随机数无效"),
    时间戳不存在(JHContents.SIGN_INTERNATIONAL_PREFIX + "timestamp_invalid", "时间戳不存在"),
    签名不存在(JHContents.SIGN_INTERNATIONAL_PREFIX + "sign_exist", "签名不存在"),
    密钥不存在(JHContents.SIGN_INTERNATIONAL_PREFIX + "key_exist", "密钥不存在"),
    密钥加密失败(JHContents.SIGN_INTERNATIONAL_PREFIX + "key_encrypt_fail", "密钥加密失败"),
    密钥解密失败(JHContents.SIGN_INTERNATIONAL_PREFIX + "key_decrypt_fail", "密钥解密失败"),
    时间戳超时(JHContents.SIGN_INTERNATIONAL_PREFIX + "timestamp_timeout", "时间戳超时"),
    签名无效(JHContents.SIGN_INTERNATIONAL_PREFIX + "sign_invalid", "签名无效"),
    加密失败(JHContents.SIGN_INTERNATIONAL_PREFIX + "encrypt_error", "加密失败"),
    解密失败(JHContents.SIGN_INTERNATIONAL_PREFIX + "decrypt_error", "解密失败"),

    标识长度超长(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "sign_length_error", "标识长度超长"),
    加密字典不存在(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "encryption_not_exist", "加密字典不存在"),
    解密字典不存在(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "encryption_not_exist", "解密字典不存在"),
    加载字典执行器不存在(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "load_decrypt_not_exist", "加载字典执行器不存在"),
    付款码不存在(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "pay_code_not_exist", "付款码不存在"),
    付款码前缀不正确(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "pay_code_prefix_error", "付款码前缀不正确"),
    付款码无效(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "pay_code_invalid", "付款码无效"),
    付款码过期(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "pay_code_timeout", "付款码过期"),
    付款码频率超限(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "pay_code_frequency_overrun", "付款码频率超限"),
    付款码解析失败(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "pay_code_parse_error", "付款码解析失败"),

    网络接口获取失败(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "net_interface_error", "网络接口获取失败"),
    证书加密失败(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "cert_encrypt_error", "证书加密失败"),
    证书解密失败(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "cert_decrypt_error", "证书解密失败"),
    证书创建失败(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "cert_build_error", "证书创建失败"),

    未找到对象信息(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "bean_not_found", "未找到对象信息"),
    API废弃(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "api_discard", "API废弃"),
    API变更(JHContents.PAYCODE_INTERNATIONAL_PREFIX + "api_change", "API变更"),;

    private String jsl;

    private String description;

    GeneralInternational(String jsl, String description) {
        this.jsl = jsl;
        this.description = description;
    }

    public String getJsl() {
        return jsl;
    }

    public String getDescription() {
        return description;
    }

}
