package com.jhscale.common.exception;

import com.jhscale.common.content.JHContents;
import com.jhscale.common.em.ServerExp;
import com.jhscale.common.model.exp.ExpKVModel;

/**
 * @author lie_w
 * @title: ProfessionalExecption
 * @projectName common
 * @description: 通用业务异常
 * @date 2020-11-0515:34
 */
public class ProfessionalException extends GeneralException {

    /**
     * @description: 异常等级
     **/
    @Override
    public String getExpLevel() {
        return JHContents.PROFESSIONAL;
    }

    /**
     * Constructs a new exception with {@code null} as its detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #initCause}.
     *
     * @param code
     * @param messages
     */
    public ProfessionalException(String code, String... messages) {
        super(code, messages);
    }

    public ProfessionalException(String code, String message) {
        super(code, message);
    }

    public ProfessionalException(String code, ExpKVModel... models) {
        super(code, models);
    }

    public ProfessionalException(String code, Object... objects) {
        super(code, objects);
    }

    public ProfessionalException(ServerExp serverExp) {
        super(serverExp);
    }

    public ProfessionalException(String message) {
        super(ServerExp.业务异常.getCode(), message);
        mapping(message);
    }

    public ProfessionalException(GeneralException exception) {
        super(exception);
    }

    public ProfessionalException(GeneralInternational international) {
        super(international.getJsl(), international.getDescription());
    }

    public ProfessionalException(Integer code, String message) {
        super(code, message);
    }
}
