package com.jhscale.common.exception;

import com.jhscale.common.content.JHContents;
import com.jhscale.common.em.ServerExp;
import com.jhscale.common.model.exp.ExpKVModel;

import java.security.PrivilegedActionException;

/**
 * @author lie_w
 * @title: SystemException
 * @projectName common
 * @description: 通用技术异常
 * @date 2020-11-0515:32
 */
public class TechnologyException extends GeneralException {
    /**
     * @description: 异常等级
     **/
    @Override
    public String getExpLevel() {
        return JHContents.TECHNOLOGY;
    }

    /**
     * Constructs a new exception with the specified cause and a detail
     * message of <tt>(cause==null ? null : cause.toString())</tt> (which
     * typically contains the class and detail message of <tt>cause</tt>).
     * This constructor is useful for exceptions that are little more than
     * wrappers for other throwables (for example, {@link
     * PrivilegedActionException}).
     *
     * @param cause    the cause (which is saved for later retrieval by the
     *                 {@link #getCause()} method).  (A <tt>null</tt> value is
     *                 permitted, and indicates that the cause is nonexistent or
     *                 unknown.)
     * @param code
     * @param messages
     * @since 1.4
     */
    public TechnologyException(Throwable cause, String code, String... messages) {
        super(cause, code, messages);
    }

    public TechnologyException(Throwable cause, String code, String message) {
        super(cause, code, message);
    }

    public TechnologyException(Throwable cause, String code, ExpKVModel... models) {
        super(cause, code, models);
    }

    public TechnologyException(Throwable cause, String code, Object... objects) {
        super(cause, code, objects);
    }

    public TechnologyException(Throwable cause, ServerExp serverExp) {
        super(cause, serverExp.getCode(), serverExp.getMessage());
    }

    public TechnologyException(Throwable cause, String message) {
        super(cause, ServerExp.业务异常.getCode(), message);
        mapping(message);
    }

    public TechnologyException(GeneralException exception) {
        super(exception);
    }

    public TechnologyException(Throwable cause, GeneralInternational international) {
        super(cause, international.getJsl(), international.getDescription());
    }

    public TechnologyException(GeneralInternational international) {
        super(international.getJsl(), international.getDescription());
    }

    public TechnologyException(Throwable cause, Integer code, String message) {
        super(cause, code, message);
    }
}
